/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp.v12;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.core.protocol.stomp.StompFrame;

public class StompFrameV12
extends StompFrame {
    private static final byte[] END_OF_FRAME = new byte[]{0, 10};
    private final List<StompFrame.Header> allHeaders = new ArrayList<StompFrame.Header>();

    public StompFrameV12(String command, Map<String, String> headers, byte[] content) {
        super(command, headers, content);
    }

    public StompFrameV12(String command) {
        super(command);
    }

    @Override
    public HornetQBuffer toHornetQBuffer() throws Exception {
        if (this.buffer == null) {
            this.buffer = this.bytesBody != null ? HornetQBuffers.dynamicBuffer(this.bytesBody.length + 512) : HornetQBuffers.dynamicBuffer(512);
            StringBuffer head = new StringBuffer();
            head.append(this.command);
            head.append("\n");
            for (StompFrame.Header h : this.allHeaders) {
                head.append(h.getEscapedKey());
                head.append(":");
                head.append(h.getEscapedValue());
                head.append("\n");
            }
            if (this.bytesBody != null && this.bytesBody.length > 0) {
                head.append("content-length");
                head.append(":");
                head.append(this.bytesBody.length);
                head.append("\n");
            }
            head.append("\n");
            this.buffer.writeBytes(head.toString().getBytes("UTF-8"));
            if (this.bytesBody != null) {
                this.buffer.writeBytes(this.bytesBody);
            }
            this.buffer.writeBytes(END_OF_FRAME);
            this.size = this.buffer.writerIndex();
        }
        return this.buffer;
    }

    @Override
    public void addHeader(String key, String val) {
        if (!this.headers.containsKey(key)) {
            this.headers.put(key, val);
            this.allHeaders.add(new StompFrame.Header(this, key, val));
        } else if (!key.equals("content-length")) {
            this.allHeaders.add(new StompFrame.Header(this, key, val));
        }
    }

    @Override
    public String escape(String str) {
        int len = str.length();
        char[] buffer = new char[2 * len];
        int iBuffer = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\r') {
                buffer[iBuffer++] = 92;
                buffer[iBuffer] = 114;
            } else if (c == '\n') {
                buffer[iBuffer++] = 92;
                buffer[iBuffer] = 110;
            } else if (c == '\\') {
                buffer[iBuffer++] = 92;
                buffer[iBuffer] = 92;
            } else if (c == ':') {
                buffer[iBuffer++] = 92;
                buffer[iBuffer] = 58;
            } else {
                buffer[iBuffer] = c;
            }
            ++iBuffer;
        }
        char[] total = new char[iBuffer];
        System.arraycopy(buffer, 0, total, 0, iBuffer);
        return new String(total);
    }
}

