/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.TopologyMember;

final class BackupTopologyListener
implements ClusterTopologyListener {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final String ownId;
    private static final int WAIT_TIMEOUT = 60;

    public BackupTopologyListener(String ownId) {
        this.ownId = ownId;
    }

    @Override
    public void nodeUP(TopologyMember topologyMember, boolean last) {
        String nodeID = topologyMember.getNodeId();
        if (this.ownId.equals(nodeID) && topologyMember.getBackup() != null) {
            this.latch.countDown();
        }
    }

    @Override
    public void nodeDown(long eventUID, String nodeID) {
    }

    boolean waitForBackup() {
        try {
            return this.latch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

