/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.hornetq.api.config.HornetQDefaultConfiguration;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.jms.JMSFactoryType;
import org.hornetq.core.config.impl.Validators;
import org.hornetq.jms.server.HornetQJMSServerBundle;
import org.hornetq.jms.server.HornetQJMSServerLogger;
import org.hornetq.jms.server.JMSServerConfigParser;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.hornetq.jms.server.config.impl.JMSConfigurationImpl;
import org.hornetq.jms.server.config.impl.JMSQueueConfigurationImpl;
import org.hornetq.jms.server.config.impl.TopicConfigurationImpl;
import org.hornetq.utils.XMLConfigurationUtil;
import org.hornetq.utils.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JMSServerConfigParserImpl
implements JMSServerConfigParser {
    protected static final String NAME_ATTR = "name";

    @Override
    public JMSConfiguration parseConfiguration(InputStream stream) throws Exception {
        InputStreamReader reader = new InputStreamReader(stream);
        String xml = XMLUtil.readerToString(reader);
        xml = XMLUtil.replaceSystemProps(xml);
        return this.parseConfiguration(XMLUtil.stringToElement(xml));
    }

    @Override
    public JMSConfiguration parseConfiguration(Node rootnode) throws Exception {
        String[] elements;
        ArrayList<JMSQueueConfiguration> queues = new ArrayList<JMSQueueConfiguration>();
        ArrayList<TopicConfiguration> topics = new ArrayList<TopicConfiguration>();
        ArrayList<ConnectionFactoryConfiguration> cfs = new ArrayList<ConnectionFactoryConfiguration>();
        String domain = HornetQDefaultConfiguration.getDefaultJmxDomain();
        Element e = (Element)rootnode;
        XMLUtil.validate(rootnode, "schema/hornetq-jms.xsd");
        for (String element : elements = new String[]{"queue", "topic", "connection-factory"}) {
            NodeList children = e.getElementsByTagName(element);
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                Node keyNode = node.getAttributes().getNamedItem(NAME_ATTR);
                if (keyNode == null) {
                    HornetQJMSServerLogger.LOGGER.jmsConfigMissingKey(node);
                    continue;
                }
                if (node.getNodeName().equals("connection-factory")) {
                    cfs.add(this.parseConnectionFactoryConfiguration(node));
                    continue;
                }
                if (node.getNodeName().equals("topic")) {
                    topics.add(this.parseTopicConfiguration(node));
                    continue;
                }
                if (!node.getNodeName().equals("queue")) continue;
                queues.add(this.parseQueueConfiguration(node));
            }
        }
        domain = XMLConfigurationUtil.getString(e, "jmx-domain", HornetQDefaultConfiguration.getDefaultJmxDomain(), Validators.NO_CHECK);
        JMSConfiguration value = this.newConfig(queues, topics, cfs, domain);
        return value;
    }

    @Override
    public TopicConfiguration parseTopicConfiguration(Node node) throws Exception {
        String topicName = node.getAttributes().getNamedItem(NAME_ATTR).getNodeValue();
        NodeList children = node.getChildNodes();
        ArrayList<String> jndiNames = new ArrayList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"entry".equals(children.item(i).getNodeName())) continue;
            String jndiElement = child.getAttributes().getNamedItem(NAME_ATTR).getNodeValue();
            jndiNames.add(jndiElement);
        }
        String[] strBindings = jndiNames.toArray(new String[jndiNames.size()]);
        return this.newTopic(topicName, strBindings);
    }

    @Override
    public JMSQueueConfiguration parseQueueConfiguration(Node node) throws Exception {
        Element e = (Element)node;
        NamedNodeMap atts = node.getAttributes();
        String queueName = atts.getNamedItem(NAME_ATTR).getNodeValue();
        String selectorString = null;
        boolean durable = XMLConfigurationUtil.getBoolean(e, "durable", true);
        NodeList children = node.getChildNodes();
        ArrayList<String> jndiNames = new ArrayList<String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("entry".equals(children.item(i).getNodeName())) {
                String jndiName = child.getAttributes().getNamedItem(NAME_ATTR).getNodeValue();
                jndiNames.add(jndiName);
                continue;
            }
            if (!"selector".equals(children.item(i).getNodeName())) continue;
            Node selectorNode = children.item(i);
            Node attNode = selectorNode.getAttributes().getNamedItem("string");
            selectorString = attNode.getNodeValue();
        }
        String[] jndiArray = jndiNames.toArray(new String[jndiNames.size()]);
        return this.newQueue(queueName, selectorString, durable, jndiArray);
    }

    @Override
    public ConnectionFactoryConfiguration parseConnectionFactoryConfiguration(Node node) throws Exception {
        ConnectionFactoryConfigurationImpl cfConfig;
        if (!node.getNodeName().equals("connection-factory")) {
            throw HornetQJMSServerBundle.BUNDLE.invalidNodeParsingCF(node.getNodeName());
        }
        Element e = (Element)node;
        String name = node.getAttributes().getNamedItem(NAME_ATTR).getNodeValue();
        String fact = e.getAttribute("signature");
        boolean isXA = XMLConfigurationUtil.getBoolean(e, "xa", false);
        JMSFactoryType factType = this.resolveFactoryType(fact, isXA);
        long clientFailureCheckPeriod = XMLConfigurationUtil.getLong(e, "client-failure-check-period", HornetQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD, Validators.MINUS_ONE_OR_GT_ZERO);
        long connectionTTL = XMLConfigurationUtil.getLong(e, "connection-ttl", HornetQClient.DEFAULT_CONNECTION_TTL, Validators.MINUS_ONE_OR_GE_ZERO);
        long callTimeout = XMLConfigurationUtil.getLong(e, "call-timeout", 30000L, Validators.GE_ZERO);
        long callFailoverTimeout = XMLConfigurationUtil.getLong(e, "call-failover-timeout", -1L, Validators.MINUS_ONE_OR_GT_ZERO);
        String clientID = XMLConfigurationUtil.getString(e, "client-id", null, Validators.NO_CHECK);
        int dupsOKBatchSize = XMLConfigurationUtil.getInteger(e, "dups-ok-batch-size", 0x100000, Validators.GT_ZERO);
        int transactionBatchSize = XMLConfigurationUtil.getInteger(e, "transaction-batch-size", 0x100000, Validators.GT_ZERO);
        int consumerWindowSize = XMLConfigurationUtil.getInteger(e, "consumer-window-size", 0x100000, Validators.MINUS_ONE_OR_GE_ZERO);
        int producerWindowSize = XMLConfigurationUtil.getInteger(e, "producer-window-size", 65536, Validators.MINUS_ONE_OR_GT_ZERO);
        int consumerMaxRate = XMLConfigurationUtil.getInteger(e, "consumer-max-rate", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        int confirmationWindowSize = XMLConfigurationUtil.getInteger(e, "confirmation-window-size", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        int producerMaxRate = XMLConfigurationUtil.getInteger(e, "producer-max-rate", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        boolean cacheLargeMessagesClient = XMLConfigurationUtil.getBoolean(e, "cache-large-message-client", false);
        int minLargeMessageSize = XMLConfigurationUtil.getInteger(e, "min-large-message-size", 102400, Validators.GT_ZERO);
        boolean compressLargeMessages = XMLConfigurationUtil.getBoolean(e, "compress-large-messages", false);
        boolean blockOnAcknowledge = XMLConfigurationUtil.getBoolean(e, "block-on-acknowledge", false);
        boolean blockOnNonDurableSend = XMLConfigurationUtil.getBoolean(e, "block-on-non-durable-send", false);
        boolean blockOnDurableSend = XMLConfigurationUtil.getBoolean(e, "block-on-durable-send", true);
        boolean autoGroup = XMLConfigurationUtil.getBoolean(e, "auto-group", false);
        boolean preAcknowledge = XMLConfigurationUtil.getBoolean(e, "pre-acknowledge", false);
        long retryInterval = XMLConfigurationUtil.getLong(e, "retry-interval", 2000L, Validators.GT_ZERO);
        double retryIntervalMultiplier = XMLConfigurationUtil.getDouble(e, "retry-interval-multiplier", HornetQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, Validators.GT_ZERO);
        long maxRetryInterval = XMLConfigurationUtil.getLong(e, "max-retry-interval", HornetQClient.DEFAULT_MAX_RETRY_INTERVAL, Validators.GT_ZERO);
        int reconnectAttempts = XMLConfigurationUtil.getInteger(e, "reconnect-attempts", 0, Validators.MINUS_ONE_OR_GE_ZERO);
        boolean failoverOnInitialConnection = XMLConfigurationUtil.getBoolean(e, "failover-on-initial-connection", false);
        boolean useGlobalPools = XMLConfigurationUtil.getBoolean(e, "use-global-pools", true);
        int scheduledThreadPoolMaxSize = XMLConfigurationUtil.getInteger(e, "scheduled-thread-pool-max-size", 5, Validators.MINUS_ONE_OR_GT_ZERO);
        int threadPoolMaxSize = XMLConfigurationUtil.getInteger(e, "thread-pool-max-size", -1, Validators.MINUS_ONE_OR_GT_ZERO);
        String connectionLoadBalancingPolicyClassName = XMLConfigurationUtil.getString(e, "connection-load-balancing-policy-class-name", HornetQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME, Validators.NOT_NULL_OR_EMPTY);
        boolean ha = XMLConfigurationUtil.getBoolean(e, "ha", false);
        String groupid = XMLConfigurationUtil.getString(e, "group-id", null, Validators.NO_CHECK);
        ArrayList<String> jndiBindings = new ArrayList<String>();
        ArrayList<String> connectorNames = new ArrayList<String>();
        String discoveryGroupName = null;
        NodeList children = node.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node entry;
            int i;
            NodeList entries;
            Node child = children.item(j);
            if ("entries".equals(child.getNodeName())) {
                entries = child.getChildNodes();
                for (i = 0; i < entries.getLength(); ++i) {
                    entry = entries.item(i);
                    if (!"entry".equals(entry.getNodeName())) continue;
                    String jndiName = entry.getAttributes().getNamedItem(NAME_ATTR).getNodeValue();
                    jndiBindings.add(jndiName);
                }
                continue;
            }
            if ("connectors".equals(child.getNodeName())) {
                entries = child.getChildNodes();
                for (i = 0; i < entries.getLength(); ++i) {
                    entry = entries.item(i);
                    if (!"connector-ref".equals(entry.getNodeName())) continue;
                    String connectorName = entry.getAttributes().getNamedItem("connector-name").getNodeValue();
                    connectorNames.add(connectorName);
                }
                continue;
            }
            if (!"discovery-group-ref".equals(child.getNodeName())) continue;
            discoveryGroupName = child.getAttributes().getNamedItem("discovery-group-name").getNodeValue();
        }
        String[] strbindings = jndiBindings.toArray(new String[jndiBindings.size()]);
        if (discoveryGroupName != null) {
            cfConfig = new ConnectionFactoryConfigurationImpl(name, ha, strbindings);
            cfConfig.setDiscoveryGroupName(discoveryGroupName);
        } else {
            ArrayList<String> connectors = new ArrayList<String>(connectorNames.size());
            for (String connectorName : connectorNames) {
                connectors.add(connectorName);
            }
            cfConfig = new ConnectionFactoryConfigurationImpl(name, ha, connectors, strbindings);
        }
        cfConfig.setFactoryType(factType);
        cfConfig.setClientID(clientID);
        cfConfig.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        cfConfig.setConnectionTTL(connectionTTL);
        cfConfig.setCallTimeout(callTimeout);
        cfConfig.setCallFailoverTimeout(callFailoverTimeout);
        cfConfig.setCacheLargeMessagesClient(cacheLargeMessagesClient);
        cfConfig.setMinLargeMessageSize(minLargeMessageSize);
        cfConfig.setCompressLargeMessages(compressLargeMessages);
        cfConfig.setConsumerWindowSize(consumerWindowSize);
        cfConfig.setConsumerMaxRate(consumerMaxRate);
        cfConfig.setConfirmationWindowSize(confirmationWindowSize);
        cfConfig.setProducerWindowSize(producerWindowSize);
        cfConfig.setProducerMaxRate(producerMaxRate);
        cfConfig.setBlockOnAcknowledge(blockOnAcknowledge);
        cfConfig.setBlockOnDurableSend(blockOnDurableSend);
        cfConfig.setBlockOnNonDurableSend(blockOnNonDurableSend);
        cfConfig.setAutoGroup(autoGroup);
        cfConfig.setPreAcknowledge(preAcknowledge);
        cfConfig.setLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
        cfConfig.setTransactionBatchSize(transactionBatchSize);
        cfConfig.setDupsOKBatchSize(dupsOKBatchSize);
        cfConfig.setUseGlobalPools(useGlobalPools);
        cfConfig.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        cfConfig.setThreadPoolMaxSize(threadPoolMaxSize);
        cfConfig.setRetryInterval(retryInterval);
        cfConfig.setRetryIntervalMultiplier(retryIntervalMultiplier);
        cfConfig.setMaxRetryInterval(maxRetryInterval);
        cfConfig.setReconnectAttempts(reconnectAttempts);
        cfConfig.setFailoverOnInitialConnection(failoverOnInitialConnection);
        cfConfig.setGroupID(groupid);
        return cfConfig;
    }

    private JMSFactoryType resolveFactoryType(String fact, boolean isXA) throws HornetQException {
        if ("".equals(fact)) {
            fact = "generic";
        }
        if (isXA) {
            if ("generic".equals(fact)) {
                return JMSFactoryType.XA_CF;
            }
            if ("queue".equals(fact)) {
                return JMSFactoryType.QUEUE_XA_CF;
            }
            if ("topic".equals(fact)) {
                return JMSFactoryType.TOPIC_XA_CF;
            }
        } else {
            if ("generic".equals(fact)) {
                return JMSFactoryType.CF;
            }
            if ("queue".equals(fact)) {
                return JMSFactoryType.QUEUE_CF;
            }
            if ("topic".equals(fact)) {
                return JMSFactoryType.TOPIC_CF;
            }
        }
        throw HornetQJMSServerBundle.BUNDLE.invalidSignatureParsingCF(fact);
    }

    protected TopicConfiguration newTopic(String topicName, String[] strBindings) {
        return new TopicConfigurationImpl(topicName, strBindings);
    }

    protected JMSQueueConfiguration newQueue(String queueName, String selectorString, boolean durable, String[] jndiArray) {
        return new JMSQueueConfigurationImpl(queueName, selectorString, durable, jndiArray);
    }

    protected JMSConfiguration newConfig(ArrayList<JMSQueueConfiguration> queues, ArrayList<TopicConfiguration> topics, ArrayList<ConnectionFactoryConfiguration> cfs, String domain) {
        JMSConfigurationImpl value = new JMSConfigurationImpl(cfs, queues, topics, domain);
        return value;
    }
}

