/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.transaction;

import java.util.Map;
import javax.transaction.xa.Xid;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionDetail;
import org.hornetq.jms.client.HornetQMessage;

public class JMSTransactionDetail
extends TransactionDetail {
    public JMSTransactionDetail(Xid xid, Transaction tx2, Long creation) throws Exception {
        super(xid, tx2, creation);
    }

    @Override
    public String decodeMessageType(ServerMessage msg) {
        byte type = msg.getType();
        switch (type) {
            case 0: {
                return "Default";
            }
            case 2: {
                return "ObjectMessage";
            }
            case 3: {
                return "TextMessage";
            }
            case 4: {
                return "ByteMessage";
            }
            case 5: {
                return "MapMessage";
            }
            case 6: {
                return "StreamMessage";
            }
        }
        return "(Unknown Type)";
    }

    @Override
    public Map<String, Object> decodeMessageProperties(ServerMessage msg) {
        try {
            return HornetQMessage.coreMaptoJMSMap(msg.toMap());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

