/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.MethodVisitor;

public class ThrowTriggerAdapter
extends RuleTriggerAdapter {
    private String exceptionClass;
    private int count;

    public ThrowTriggerAdapter(ClassVisitor cv, TransformContext transformContext, String exceptionClass, int count) {
        super(cv, transformContext);
        this.exceptionClass = exceptionClass;
        this.count = count;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectIntoMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new ThrowTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new ThrowTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class ThrowTriggerConstructorAdapter
    extends ThrowTriggerMethodAdapter {
        ThrowTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.latched = true;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (this.latched && ThrowTriggerAdapter.this.isSuperOrSiblingConstructorCall(opcode, owner, name)) {
                this.latched = false;
            }
        }
    }

    private class ThrowTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        protected boolean latched;
        private int visitedCount;

        ThrowTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
            this.visitedCount = 0;
            this.latched = false;
        }

        @Override
        public void visitInsn(int opcode) {
            if (!(opcode != 191 || ThrowTriggerAdapter.this.count != 0 && this.visitedCount >= ThrowTriggerAdapter.this.count || this.inRethrowHandler() || this.inBytemanHandler())) {
                ++this.visitedCount;
                if (!(this.latched || ThrowTriggerAdapter.this.count != 0 && this.visitedCount != ThrowTriggerAdapter.this.count)) {
                    this.injectTriggerPoint();
                }
            }
            super.visitInsn(opcode);
        }
    }
}

