/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter.cfg;

import org.jboss.byteman.agent.adapter.OpcodesHelper;

public class InstructionSequence {
    private int[] instructionOffsets = new int[3];
    private int numInstructions;
    private int[] encodedInstructions = new int[6];
    private int numEncoded;

    private void ensureSpace(int count) {
        int i;
        int length = this.instructionOffsets.length;
        if (this.numInstructions == length) {
            int[] newOffsets = new int[length * 2];
            for (i = 0; i < this.numInstructions; ++i) {
                newOffsets[i] = this.instructionOffsets[i];
            }
            this.instructionOffsets = newOffsets;
        }
        if (this.numEncoded + count + 1 >= (length = this.encodedInstructions.length)) {
            int[] newEncoded = new int[length * 2];
            for (i = 0; i < this.numEncoded; ++i) {
                newEncoded[i] = this.encodedInstructions[i];
            }
            this.encodedInstructions = newEncoded;
        }
    }

    public int size() {
        return this.numInstructions;
    }

    public int get(int i) {
        int offset = this.instructionOffsets[i];
        return this.encodedInstructions[offset];
    }

    public int getType(int i) {
        int offset = this.instructionOffsets[i];
        int insn = this.encodedInstructions[offset];
        return OpcodesHelper.insnType(insn);
    }

    public int getArgCount(int i) {
        int offset = this.instructionOffsets[i];
        int nextOffset = offset == this.numInstructions - 1 ? this.numEncoded : this.instructionOffsets[i + 1];
        return nextOffset - (offset + 1);
    }

    public int getArg(int i, int j) {
        int offset = this.instructionOffsets[i];
        return this.encodedInstructions[offset + j + 1];
    }

    public int add(int insn) {
        int result = this.numInstructions;
        this.ensureSpace(0);
        this.instructionOffsets[this.numInstructions++] = this.numEncoded;
        this.encodedInstructions[this.numEncoded++] = insn;
        return result;
    }

    public int add(int insn, int arg1) {
        int result = this.numInstructions;
        this.ensureSpace(1);
        this.instructionOffsets[this.numInstructions++] = this.numEncoded;
        this.encodedInstructions[this.numEncoded++] = insn;
        this.encodedInstructions[this.numEncoded++] = arg1;
        return result;
    }

    public int add(int insn, int arg1, int arg2) {
        int result = this.numInstructions;
        this.ensureSpace(2);
        this.instructionOffsets[this.numInstructions++] = this.numEncoded;
        this.encodedInstructions[this.numEncoded++] = insn;
        this.encodedInstructions[this.numEncoded++] = arg1;
        this.encodedInstructions[this.numEncoded++] = arg2;
        return result;
    }

    public int add(int insn, int arg1, int arg2, int arg3) {
        int result = this.numInstructions;
        this.ensureSpace(3);
        this.instructionOffsets[this.numInstructions++] = this.numEncoded;
        this.encodedInstructions[this.numEncoded++] = insn;
        this.encodedInstructions[this.numEncoded++] = arg1;
        this.encodedInstructions[this.numEncoded++] = arg2;
        this.encodedInstructions[this.numEncoded++] = arg3;
        return result;
    }

    public int add(int insn, int[] args) {
        int result = this.numInstructions;
        this.ensureSpace(args.length);
        this.instructionOffsets[this.numInstructions++] = this.numEncoded;
        this.encodedInstructions[this.numEncoded++] = insn;
        for (int i = 0; i < args.length; ++i) {
            this.encodedInstructions[this.numEncoded++] = args[i];
        }
        return result;
    }
}

