/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.binding.Binding;
import org.jboss.byteman.rule.binding.Bindings;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class DollarExpression
extends AssignableExpression {
    private String name;
    private int index;
    private Binding binding;
    public static final int HELPER_IDX = -1;
    public static final int BIND_IDX = -2;
    public static final int LOCAL_IDX = -3;
    public static final int RETURN_VALUE_IDX = -4;
    public static final int THROWABLE_VALUE_IDX = -5;
    public static final int PARAM_COUNT_IDX = -6;
    public static final int PARAM_ARRAY_IDX = -7;
    public static final int INVOKE_PARAM_ARRAY_IDX = -8;

    public DollarExpression(Rule rule, Type type, ParseNode token, int index) {
        super(rule, type, token);
        this.name = index == -1 ? "$$" : (index == -4 ? "$!" : (index == -5 ? "$^" : (index == -6 ? "$#" : (index == -7 ? "$*" : (index == -8 ? "$@" : "$" + Integer.toString(index))))));
        this.index = index;
        this.binding = null;
    }

    public DollarExpression(Rule rule, Type type, ParseNode token, String name) {
        super(rule, type, token);
        this.index = -3;
        this.name = "$" + name;
        this.binding = null;
    }

    @Override
    public void bind() throws TypeException {
        this.bind(false);
    }

    @Override
    public void bindAssign() throws TypeException {
        if (this.name.equals("$0") || this.name.equals("$this")) {
            throw new TypeException("invalid assignment to final variable " + this.name + this.getPos());
        }
        if (this.name.equals("$^")) {
            throw new TypeException("invalid assignment to throwable variable " + this.name + this.getPos());
        }
        if (this.name.equals("$#")) {
            throw new TypeException("invalid assignment to param count variable " + this.name + this.getPos());
        }
        if (this.name.equals("$*")) {
            throw new TypeException("invalid assignment to param array variable " + this.name + this.getPos());
        }
        if (this.name.equals("$@")) {
            throw new TypeException("invalid assignment to invoke param array variable " + this.name + this.getPos());
        }
        this.bind(true);
    }

    public void bind(boolean isUpdateable) throws TypeException {
        Bindings bindings = this.getBindings();
        this.binding = bindings.lookup(this.name);
        if (this.binding == null) {
            this.binding = new Binding(this.rule, this.name, null);
            bindings.append(this.binding);
        }
        if (isUpdateable) {
            this.binding.setUpdated();
        }
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.typeCheckAny();
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("DollarExpression.typeCheck : invalid expected type " + expected.getName() + " for bound parameter " + this.name + this.getPos());
        }
        return this.type;
    }

    @Override
    public Type typeCheckAssign(Type expected) throws TypeException {
        this.typeCheckAny();
        if (Type.dereference(expected).isDefined() && !this.type.isAssignableFrom(expected)) {
            throw new TypeException("DollarExpression.typeCheck : invalid value type " + expected.getName() + " for assignment to bound parameter " + this.name + this.getPos());
        }
        return this.type;
    }

    private void typeCheckAny() {
        if (this.binding.isAlias()) {
            this.binding = this.binding.getAlias();
        }
        this.type = this.binding.getType();
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return helper.getBinding(this.binding.getName());
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        int expected;
        compileContext.notifySourceLine(this.line);
        String targetName = this.binding.getName();
        int currentStack = compileContext.getStackCount();
        int n = expected = this.type.getNBytes() > 4 ? 2 : 1;
        if (this.index == -1) {
            mv.visitVarInsn(25, 0);
            compileContext.addStackCount(1);
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(targetName);
            compileContext.addStackCount(2);
            mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "getBinding", "(Ljava/lang/String;)Ljava/lang/Object;");
            compileContext.addStackCount(-1);
            if (this.type.isPrimitive()) {
                Type boxType = Type.boxType(this.type);
                this.compileObjectConversion(Type.OBJECT, boxType, mv, compileContext);
                this.compileUnbox(boxType, this.type, mv, compileContext);
            } else {
                this.compileObjectConversion(Type.OBJECT, this.type, mv, compileContext);
            }
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("DollarExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }

    @Override
    public Object interpretAssign(HelperAdapter helperAdapter, Object value) throws ExecuteException {
        helperAdapter.setBinding(this.binding.getName(), value);
        return value;
    }

    @Override
    public void compileAssign(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        int size;
        compileContext.notifySourceLine(this.line);
        String targetName = this.binding.getName();
        int currentStack = compileContext.getStackCount();
        int n = size = this.type.getNBytes() > 4 ? 2 : 1;
        if (this.index == -1) {
            throw new CompileException("DollarExpression.compileAssign : invalid assignment to helper binding $$");
        }
        if (size == 2) {
            mv.visitInsn(92);
        } else {
            mv.visitInsn(89);
        }
        mv.visitVarInsn(25, 0);
        if (size == 2) {
            mv.visitInsn(91);
            mv.visitInsn(87);
        } else {
            mv.visitInsn(95);
        }
        mv.visitLdcInsn(targetName);
        if (size == 2) {
            mv.visitInsn(91);
            compileContext.addStackCount(5);
            mv.visitInsn(87);
            compileContext.addStackCount(-1);
        } else {
            compileContext.addStackCount(3);
            mv.visitInsn(95);
        }
        this.compileObjectConversion(this.type, Type.OBJECT, mv, compileContext);
        mv.visitMethodInsn(185, Type.internalName(HelperAdapter.class), "setBinding", "(Ljava/lang/String;Ljava/lang/Object;)V");
        compileContext.addStackCount(-3);
        if (compileContext.getStackCount() != currentStack) {
            throw new CompileException("variable.compileAssignment : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack);
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write(this.name);
    }
}

