/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.HashMap;
import javax.naming.Name;
import org.jboss.naming.JndiPermissionCollection;

public final class JndiPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int BIND = 1;
    public static final int REBIND = 2;
    public static final int UNBIND = 4;
    public static final int LOOKUP = 8;
    public static final int LIST = 16;
    public static final int LIST_BINDINGS = 32;
    public static final int CREATE_SUBCONTEXT = 64;
    private static final int ACTION_COUNT = 7;
    public static final int ALL = 127;
    public static final int NONE = 0;
    public static final String BIND_ACTION = "bind";
    public static final String REBIND_ACTION = "rebind";
    public static final String UNBIND_ACTION = "unbind";
    public static final String LOOKUP_ACTION = "lookup";
    public static final String LIST_ACTION = "list";
    public static final String LIST_BINDINGS_ACTION = "listBindings";
    public static final String ALL_ACTION = "*";
    public static final String CREATE_SUBCONTEXT_ACTION = "createSubcontext";
    private static final String[] ALL_ACTIONS = new String[]{"bind", "rebind", "unbind", "lookup", "list", "listBindings", "createSubcontext"};
    private static final HashMap<String, Integer> actionMap = new HashMap();
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';

    private void init(int mask) {
        int last;
        if ((mask & 0x7F) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.cpath = this.getName();
        if (this.cpath == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = mask;
        if (this.cpath.equals("<<ALL BINDINGS>>")) {
            this.directory = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        int len = this.cpath.length();
        int n = last = len > 0 ? (int)this.cpath.charAt(len - 1) : 0;
        if (last == 45 && this.cpath.charAt(len - 2) == '/') {
            this.directory = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --len);
        } else if (last == 42 && this.cpath.charAt(len - 2) == '/') {
            this.directory = true;
            this.cpath = this.cpath.substring(0, --len);
        }
    }

    public JndiPermission(String path, String actions2) {
        super(path);
        this.init(JndiPermission.getMask(actions2));
    }

    public JndiPermission(Name path, String actions2) {
        super(path.toString());
        this.init(JndiPermission.getMask(actions2));
    }

    JndiPermission(String path, int mask) {
        super(path);
        this.init(mask);
    }

    public JndiPermission(Name path, int mask) {
        super(path.toString());
        this.init(mask);
    }

    public boolean implies(Permission p) {
        if (!(p instanceof JndiPermission)) {
            return false;
        }
        JndiPermission that = (JndiPermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(JndiPermission that) {
        if (this.directory) {
            if (this.recursive) {
                if (that.directory) {
                    return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
                }
                return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
            }
            if (that.directory) {
                if (that.recursive) {
                    return false;
                }
                return this.cpath.equals(that.cpath);
            }
            int last = that.cpath.lastIndexOf(47);
            if (last == -1) {
                return false;
            }
            return this.cpath.length() == last + 1 && this.cpath.regionMatches(0, that.cpath, 0, last + 1);
        }
        if (that.directory) {
            return false;
        }
        return this.cpath.equals(that.cpath);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JndiPermission)) {
            return false;
        }
        JndiPermission that = (JndiPermission)obj;
        return this.mask == that.mask && this.cpath.equals(that.cpath) && this.directory == that.directory && this.recursive == that.recursive;
    }

    public int hashCode() {
        return this.cpath.hashCode();
    }

    private static int getMask(String actions2) {
        String[] sa;
        int mask = 0;
        if (actions2 == null || actions2.length() == 0) {
            return mask;
        }
        if (actions2 == LOOKUP_ACTION) {
            return 8;
        }
        if (actions2 == REBIND_ACTION) {
            return 2;
        }
        if (actions2 == BIND_ACTION) {
            return 1;
        }
        if (actions2 == UNBIND_ACTION) {
            return 4;
        }
        if (actions2 == LIST_ACTION) {
            return 16;
        }
        if (actions2 == LIST_BINDINGS_ACTION) {
            return 32;
        }
        if (actions2 == CREATE_SUBCONTEXT_ACTION) {
            return 64;
        }
        for (String s : sa = actions2.split(",")) {
            String key = s.toLowerCase();
            if (!actionMap.containsKey(key)) {
                throw new IllegalArgumentException("invalid permission, unknown action: " + s);
            }
            int i = actionMap.get(key);
            mask |= i;
        }
        return mask;
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean insertComma = false;
        for (int n = 0; n < 7; ++n) {
            int action = 1 << n;
            if ((mask & action) != action) continue;
            if (insertComma) {
                sb.append(',');
            }
            sb.append(ALL_ACTIONS[n]);
            insertComma = true;
        }
        return sb.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = JndiPermission.getActions(this.mask);
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new JndiPermissionCollection();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(JndiPermission.getMask(this.actions));
    }

    static {
        actionMap.put(BIND_ACTION, 1);
        actionMap.put(REBIND_ACTION, 2);
        actionMap.put(UNBIND_ACTION, 4);
        actionMap.put(LOOKUP_ACTION, 8);
        actionMap.put(LIST_ACTION, 16);
        actionMap.put(LIST_BINDINGS_ACTION.toLowerCase(), 32);
        actionMap.put(CREATE_SUBCONTEXT_ACTION.toLowerCase(), 64);
        actionMap.put(ALL_ACTION, 127);
    }
}

