/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyGoAwayFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyWindowUpdateFrame;
import org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import org.jboss.netty.handler.codec.spdy.SpdyDataFrame;
import org.jboss.netty.handler.codec.spdy.SpdyGoAwayFrame;
import org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import org.jboss.netty.handler.codec.spdy.SpdyPingFrame;
import org.jboss.netty.handler.codec.spdy.SpdyProtocolException;
import org.jboss.netty.handler.codec.spdy.SpdyRstStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdySession;
import org.jboss.netty.handler.codec.spdy.SpdySessionStatus;
import org.jboss.netty.handler.codec.spdy.SpdySettingsFrame;
import org.jboss.netty.handler.codec.spdy.SpdyStreamStatus;
import org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdyWindowUpdateFrame;

public class SpdySessionHandler
extends SimpleChannelUpstreamHandler
implements ChannelDownstreamHandler {
    private static final SpdyProtocolException PROTOCOL_EXCEPTION = new SpdyProtocolException();
    private final SpdySession spdySession = new SpdySession();
    private volatile int lastGoodStreamID;
    private volatile int remoteConcurrentStreams;
    private volatile int localConcurrentStreams;
    private volatile int maxConcurrentStreams;
    private static final int DEFAULT_WINDOW_SIZE = 65536;
    private volatile int initialSendWindowSize = 65536;
    private volatile int initialReceiveWindowSize = 65536;
    private final Object flowControlLock = new Object();
    private final AtomicInteger pings = new AtomicInteger();
    private volatile boolean sentGoAwayFrame;
    private volatile boolean receivedGoAwayFrame;
    private volatile ChannelFuture closeSessionFuture;
    private final boolean server;
    private final boolean flowControl;

    @Deprecated
    public SpdySessionHandler(boolean server) {
        this(2, server);
    }

    public SpdySessionHandler(int version, boolean server) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        this.server = server;
        this.flowControl = version >= 3;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            int streamID = spdyDataFrame.getStreamId();
            if (!this.spdySession.isActiveStream(streamID)) {
                if (streamID <= this.lastGoodStreamID) {
                    this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                } else if (!this.sentGoAwayFrame) {
                    this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.INVALID_STREAM);
                }
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamID)) {
                this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.STREAM_ALREADY_CLOSED);
                return;
            }
            if (!this.isRemoteInitiatedID(streamID) && !this.spdySession.hasReceivedReply(streamID)) {
                this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.flowControl) {
                int deltaWindowSize = -1 * spdyDataFrame.getData().readableBytes();
                int newWindowSize = this.spdySession.updateReceiveWindowSize(streamID, deltaWindowSize);
                if (newWindowSize < this.spdySession.getReceiveWindowSizeLowerBound(streamID)) {
                    this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                    return;
                }
                if (newWindowSize < 0) {
                    while (spdyDataFrame.getData().readableBytes() > this.initialReceiveWindowSize) {
                        DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamID);
                        partialDataFrame.setData(spdyDataFrame.getData().readSlice(this.initialReceiveWindowSize));
                        Channels.fireMessageReceived(ctx, (Object)partialDataFrame, e.getRemoteAddress());
                    }
                }
                if (newWindowSize <= this.initialReceiveWindowSize / 2 && !spdyDataFrame.isLast()) {
                    deltaWindowSize = this.initialReceiveWindowSize - newWindowSize;
                    this.spdySession.updateReceiveWindowSize(streamID, deltaWindowSize);
                    DefaultSpdyWindowUpdateFrame spdyWindowUpdateFrame = new DefaultSpdyWindowUpdateFrame(streamID, deltaWindowSize);
                    Channels.write(ctx, Channels.future(e.getChannel()), spdyWindowUpdateFrame, e.getRemoteAddress());
                }
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamID, true);
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamID = spdySynStreamFrame.getStreamId();
            if (spdySynStreamFrame.isInvalid() || !this.isRemoteInitiatedID(streamID) || this.spdySession.isActiveStream(streamID)) {
                this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (streamID <= this.lastGoodStreamID) {
                this.issueSessionError(ctx, e.getChannel(), e.getRemoteAddress(), SpdySessionStatus.PROTOCOL_ERROR);
                return;
            }
            byte priority = spdySynStreamFrame.getPriority();
            if (!this.acceptStream(streamID, priority, remoteSideClosed = spdySynStreamFrame.isLast(), localSideClosed = spdySynStreamFrame.isUnidirectional())) {
                this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.REFUSED_STREAM);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamID = spdySynReplyFrame.getStreamId();
            if (spdySynReplyFrame.isInvalid() || this.isRemoteInitiatedID(streamID) || this.spdySession.isRemoteSideClosed(streamID)) {
                this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (this.spdySession.hasReceivedReply(streamID)) {
                this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.STREAM_IN_USE);
                return;
            }
            this.spdySession.receivedReply(streamID);
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamID, true);
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(spdyRstStreamFrame.getStreamId());
        } else if (msg instanceof SpdySettingsFrame) {
            int newInitialWindowSize;
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.updateConcurrentStreams(newConcurrentStreams, true);
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            if (this.flowControl && (newInitialWindowSize = spdySettingsFrame.getValue(7)) >= 0) {
                this.updateInitialSendWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getId())) {
                Channels.write(ctx, Channels.future(e.getChannel()), spdyPingFrame, e.getRemoteAddress());
                return;
            }
            if (this.pings.get() == 0) {
                return;
            }
            this.pings.getAndDecrement();
        } else if (msg instanceof SpdyGoAwayFrame) {
            this.receivedGoAwayFrame = true;
        } else if (msg instanceof SpdyHeadersFrame) {
            SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
            int streamID = spdyHeadersFrame.getStreamId();
            if (spdyHeadersFrame.isInvalid()) {
                this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.PROTOCOL_ERROR);
                return;
            }
            if (this.spdySession.isRemoteSideClosed(streamID)) {
                this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.INVALID_STREAM);
                return;
            }
            if (spdyHeadersFrame.isLast()) {
                this.halfCloseStream(streamID, true);
            }
        } else if (msg instanceof SpdyWindowUpdateFrame) {
            if (this.flowControl) {
                SpdyWindowUpdateFrame spdyWindowUpdateFrame = (SpdyWindowUpdateFrame)msg;
                int streamID = spdyWindowUpdateFrame.getStreamId();
                int deltaWindowSize = spdyWindowUpdateFrame.getDeltaWindowSize();
                if (this.spdySession.isLocalSideClosed(streamID)) {
                    return;
                }
                if (this.spdySession.getSendWindowSize(streamID) > Integer.MAX_VALUE - deltaWindowSize) {
                    this.issueStreamError(ctx, e.getRemoteAddress(), streamID, SpdyStreamStatus.FLOW_CONTROL_ERROR);
                    return;
                }
                this.updateSendWindowSize(ctx, streamID, deltaWindowSize);
            }
            return;
        }
        super.messageReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof SpdyProtocolException) {
            this.issueSessionError(ctx, e.getChannel(), null, SpdySessionStatus.PROTOCOL_ERROR);
        }
        super.exceptionCaught(ctx, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        ChannelEvent e;
        if (evt instanceof ChannelStateEvent) {
            e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    this.sendGoAwayFrame(ctx, (ChannelStateEvent)e);
                    return;
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        e = (MessageEvent)evt;
        Object msg = e.getMessage();
        if (msg instanceof SpdyDataFrame) {
            SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
            final int streamID = spdyDataFrame.getStreamId();
            if (this.spdySession.isLocalSideClosed(streamID)) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (this.flowControl) {
                Object object = this.flowControlLock;
                synchronized (object) {
                    int dataLength = spdyDataFrame.getData().readableBytes();
                    int sendWindowSize = this.spdySession.getSendWindowSize(streamID);
                    if (sendWindowSize <= 0) {
                        this.spdySession.putPendingWrite(streamID, (MessageEvent)e);
                        return;
                    }
                    if (sendWindowSize < dataLength) {
                        this.spdySession.updateSendWindowSize(streamID, -1 * sendWindowSize);
                        DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamID);
                        partialDataFrame.setData(spdyDataFrame.getData().readSlice(sendWindowSize));
                        this.spdySession.putPendingWrite(streamID, (MessageEvent)e);
                        ChannelFuture writeFuture = Channels.future(e.getChannel());
                        final SocketAddress remoteAddress = e.getRemoteAddress();
                        final ChannelHandlerContext context = ctx;
                        e.getFuture().addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    SpdySessionHandler.this.issueStreamError(context, remoteAddress, streamID, SpdyStreamStatus.INTERNAL_ERROR);
                                }
                            }
                        });
                        Channels.write(ctx, writeFuture, partialDataFrame, remoteAddress);
                        return;
                    }
                    this.spdySession.updateSendWindowSize(streamID, -1 * dataLength);
                    final SocketAddress remoteAddress = e.getRemoteAddress();
                    final ChannelHandlerContext context = ctx;
                    e.getFuture().addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                SpdySessionHandler.this.issueStreamError(context, remoteAddress, streamID, SpdyStreamStatus.INTERNAL_ERROR);
                            }
                        }
                    });
                }
            }
            if (spdyDataFrame.isLast()) {
                this.halfCloseStream(streamID, false);
            }
        } else if (msg instanceof SpdySynStreamFrame) {
            boolean localSideClosed;
            boolean remoteSideClosed;
            SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
            int streamID = spdySynStreamFrame.getStreamId();
            if (this.isRemoteInitiatedID(streamID)) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            byte priority = spdySynStreamFrame.getPriority();
            if (!this.acceptStream(streamID, priority, remoteSideClosed = spdySynStreamFrame.isUnidirectional(), localSideClosed = spdySynStreamFrame.isLast())) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        } else if (msg instanceof SpdySynReplyFrame) {
            SpdySynReplyFrame spdySynReplyFrame = (SpdySynReplyFrame)msg;
            int streamID = spdySynReplyFrame.getStreamId();
            if (!this.isRemoteInitiatedID(streamID) || this.spdySession.isLocalSideClosed(streamID)) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (spdySynReplyFrame.isLast()) {
                this.halfCloseStream(streamID, false);
            }
        } else if (msg instanceof SpdyRstStreamFrame) {
            SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
            this.removeStream(spdyRstStreamFrame.getStreamId());
        } else if (msg instanceof SpdySettingsFrame) {
            int newInitialWindowSize;
            SpdySettingsFrame spdySettingsFrame = (SpdySettingsFrame)msg;
            int newConcurrentStreams = spdySettingsFrame.getValue(4);
            if (newConcurrentStreams >= 0) {
                this.updateConcurrentStreams(newConcurrentStreams, false);
            }
            if (spdySettingsFrame.isPersisted(7)) {
                spdySettingsFrame.removeValue(7);
            }
            spdySettingsFrame.setPersistValue(7, false);
            if (this.flowControl && (newInitialWindowSize = spdySettingsFrame.getValue(7)) >= 0) {
                this.updateInitialReceiveWindowSize(newInitialWindowSize);
            }
        } else if (msg instanceof SpdyPingFrame) {
            SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
            if (this.isRemoteInitiatedID(spdyPingFrame.getId())) {
                e.getFuture().setFailure(new IllegalArgumentException("invalid PING ID: " + spdyPingFrame.getId()));
                return;
            }
            this.pings.getAndIncrement();
        } else {
            if (msg instanceof SpdyGoAwayFrame) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
            if (msg instanceof SpdyHeadersFrame) {
                SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
                int streamID = spdyHeadersFrame.getStreamId();
                if (this.spdySession.isLocalSideClosed(streamID)) {
                    e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                    return;
                }
                if (spdyHeadersFrame.isLast()) {
                    this.halfCloseStream(streamID, false);
                }
            } else if (msg instanceof SpdyWindowUpdateFrame) {
                e.getFuture().setFailure(PROTOCOL_EXCEPTION);
                return;
            }
        }
        ctx.sendDownstream(evt);
    }

    private void issueSessionError(ChannelHandlerContext ctx, Channel channel, SocketAddress remoteAddress, SpdySessionStatus status) {
        ChannelFuture future = this.sendGoAwayFrame(ctx, channel, remoteAddress, status);
        future.addListener(ChannelFutureListener.CLOSE);
    }

    private void issueStreamError(ChannelHandlerContext ctx, SocketAddress remoteAddress, int streamID, SpdyStreamStatus status) {
        boolean fireMessageReceived = !this.spdySession.isRemoteSideClosed(streamID);
        this.removeStream(streamID);
        DefaultSpdyRstStreamFrame spdyRstStreamFrame = new DefaultSpdyRstStreamFrame(streamID, status);
        Channels.write(ctx, Channels.future(ctx.getChannel()), spdyRstStreamFrame, remoteAddress);
        if (fireMessageReceived) {
            Channels.fireMessageReceived(ctx, (Object)spdyRstStreamFrame, remoteAddress);
        }
    }

    private boolean isRemoteInitiatedID(int id) {
        boolean serverID = SpdyCodecUtil.isServerId(id);
        return this.server && !serverID || !this.server && serverID;
    }

    private void updateConcurrentStreams(int newConcurrentStreams, boolean remote) {
        if (remote) {
            this.remoteConcurrentStreams = newConcurrentStreams;
        } else {
            this.localConcurrentStreams = newConcurrentStreams;
        }
        if (this.localConcurrentStreams == this.remoteConcurrentStreams) {
            this.maxConcurrentStreams = this.localConcurrentStreams;
            return;
        }
        if (this.localConcurrentStreams == 0) {
            this.maxConcurrentStreams = this.remoteConcurrentStreams;
            return;
        }
        if (this.remoteConcurrentStreams == 0) {
            this.maxConcurrentStreams = this.localConcurrentStreams;
            return;
        }
        this.maxConcurrentStreams = this.localConcurrentStreams > this.remoteConcurrentStreams ? this.remoteConcurrentStreams : this.localConcurrentStreams;
    }

    private synchronized void updateInitialSendWindowSize(int newInitialWindowSize) {
        int deltaWindowSize = newInitialWindowSize - this.initialSendWindowSize;
        this.initialSendWindowSize = newInitialWindowSize;
        for (Integer StreamID : this.spdySession.getActiveStreams()) {
            this.spdySession.updateSendWindowSize(StreamID, deltaWindowSize);
        }
    }

    private synchronized void updateInitialReceiveWindowSize(int newInitialWindowSize) {
        int deltaWindowSize = newInitialWindowSize - this.initialReceiveWindowSize;
        this.initialReceiveWindowSize = newInitialWindowSize;
        this.spdySession.updateAllReceiveWindowSizes(deltaWindowSize);
    }

    private synchronized boolean acceptStream(int streamID, byte priority, boolean remoteSideClosed, boolean localSideClosed) {
        if (this.receivedGoAwayFrame || this.sentGoAwayFrame) {
            return false;
        }
        int maxConcurrentStreams = this.maxConcurrentStreams;
        if (maxConcurrentStreams != 0 && this.spdySession.numActiveStreams() >= maxConcurrentStreams) {
            return false;
        }
        this.spdySession.acceptStream(streamID, priority, remoteSideClosed, localSideClosed, this.initialSendWindowSize, this.initialReceiveWindowSize);
        if (this.isRemoteInitiatedID(streamID)) {
            this.lastGoodStreamID = streamID;
        }
        return true;
    }

    private void halfCloseStream(int streamID, boolean remote) {
        if (remote) {
            this.spdySession.closeRemoteSide(streamID);
        } else {
            this.spdySession.closeLocalSide(streamID);
        }
        if (this.closeSessionFuture != null && this.spdySession.noActiveStreams()) {
            this.closeSessionFuture.setSuccess();
        }
    }

    private void removeStream(int streamID) {
        this.spdySession.removeStream(streamID);
        if (this.closeSessionFuture != null && this.spdySession.noActiveStreams()) {
            this.closeSessionFuture.setSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSendWindowSize(ChannelHandlerContext ctx, final int streamID, int deltaWindowSize) {
        Object object = this.flowControlLock;
        synchronized (object) {
            MessageEvent e;
            int newWindowSize = this.spdySession.updateSendWindowSize(streamID, deltaWindowSize);
            while (newWindowSize > 0 && (e = this.spdySession.getPendingWrite(streamID)) != null) {
                SpdyDataFrame spdyDataFrame = (SpdyDataFrame)e.getMessage();
                int dataFrameSize = spdyDataFrame.getData().readableBytes();
                if (newWindowSize >= dataFrameSize) {
                    this.spdySession.removePendingWrite(streamID);
                    newWindowSize = this.spdySession.updateSendWindowSize(streamID, -1 * dataFrameSize);
                    final SocketAddress remoteAddress = e.getRemoteAddress();
                    final ChannelHandlerContext context = ctx;
                    e.getFuture().addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (!future.isSuccess()) {
                                SpdySessionHandler.this.issueStreamError(context, remoteAddress, streamID, SpdyStreamStatus.INTERNAL_ERROR);
                            }
                        }
                    });
                    if (spdyDataFrame.isLast()) {
                        this.halfCloseStream(streamID, false);
                    }
                    Channels.write(ctx, e.getFuture(), spdyDataFrame, e.getRemoteAddress());
                    continue;
                }
                this.spdySession.updateSendWindowSize(streamID, -1 * newWindowSize);
                DefaultSpdyDataFrame partialDataFrame = new DefaultSpdyDataFrame(streamID);
                partialDataFrame.setData(spdyDataFrame.getData().readSlice(newWindowSize));
                ChannelFuture writeFuture = Channels.future(e.getChannel());
                final SocketAddress remoteAddress = e.getRemoteAddress();
                final ChannelHandlerContext context = ctx;
                e.getFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            SpdySessionHandler.this.issueStreamError(context, remoteAddress, streamID, SpdyStreamStatus.INTERNAL_ERROR);
                        }
                    }
                });
                Channels.write(ctx, writeFuture, partialDataFrame, remoteAddress);
                newWindowSize = 0;
            }
        }
    }

    private void sendGoAwayFrame(ChannelHandlerContext ctx, ChannelStateEvent e) {
        if (!e.getChannel().isConnected()) {
            ctx.sendDownstream(e);
            return;
        }
        ChannelFuture future = this.sendGoAwayFrame(ctx, e.getChannel(), null, SpdySessionStatus.OK);
        if (this.spdySession.noActiveStreams()) {
            future.addListener(new ClosingChannelFutureListener(ctx, e));
        } else {
            this.closeSessionFuture = Channels.future(e.getChannel());
            this.closeSessionFuture.addListener(new ClosingChannelFutureListener(ctx, e));
        }
    }

    private synchronized ChannelFuture sendGoAwayFrame(ChannelHandlerContext ctx, Channel channel, SocketAddress remoteAddress, SpdySessionStatus status) {
        if (!this.sentGoAwayFrame) {
            this.sentGoAwayFrame = true;
            DefaultSpdyGoAwayFrame spdyGoAwayFrame = new DefaultSpdyGoAwayFrame(this.lastGoodStreamID, status);
            ChannelFuture future = Channels.future(channel);
            Channels.write(ctx, future, spdyGoAwayFrame, remoteAddress);
            return future;
        }
        return Channels.succeededFuture(channel);
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final ChannelStateEvent e;

        ClosingChannelFutureListener(ChannelHandlerContext ctx, ChannelStateEvent e) {
            this.ctx = ctx;
            this.e = e;
        }

        public void operationComplete(ChannelFuture sentGoAwayFuture) throws Exception {
            if (!(sentGoAwayFuture.getCause() instanceof ClosedChannelException)) {
                Channels.close(this.ctx, this.e.getFuture());
            } else {
                this.e.getFuture().setSuccess();
            }
        }
    }
}

