/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionLocalDelegate;

@Deprecated
public class TransactionLocalDelegateImpl
implements TransactionLocalDelegate {
    protected TransactionManager manager;
    protected static ConcurrentHashMap<Transaction, TransactionLocalSynchronization> synchronizationsByTransaction = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TransactionLocalSynchronization getSynchronization(Transaction tx2, boolean create) {
        Transaction transaction = tx2;
        synchronized (transaction) {
            TransactionLocalSynchronization result = synchronizationsByTransaction.get(tx2);
            if (result == null && create) {
                result = new TransactionLocalSynchronization(tx2);
                try {
                    tx2.registerSynchronization(result);
                }
                catch (RollbackException e) {
                    throw new IllegalStateException("Transaction already rolled back or marked for rollback");
                }
                catch (SystemException e) {
                    throw new RuntimeException("Error registering transaction synchronization with " + tx2, e);
                }
                synchronizationsByTransaction.put(tx2, result);
            }
            return result;
        }
    }

    protected static void removeSynchronization(Transaction tx2) {
        synchronizationsByTransaction.remove(tx2);
    }

    public TransactionLocalDelegateImpl(TransactionManager manager) {
        this.manager = manager;
    }

    @Override
    public void lock(TransactionLocal local, Transaction tx2) throws InterruptedException {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx2, true);
        sync.lock(local);
    }

    @Override
    public void unlock(TransactionLocal local, Transaction tx2) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx2, false);
        if (sync == null) {
            throw new IllegalStateException("No synchronization found tx=" + tx2 + " local=" + local);
        }
        sync.unlock(local);
    }

    @Override
    public Object getValue(TransactionLocal local, Transaction tx2) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx2, false);
        if (sync == null) {
            return null;
        }
        return sync.getValue(local);
    }

    @Override
    public void storeValue(TransactionLocal local, Transaction tx2, Object value) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx2, true);
        sync.setValue(local, value);
    }

    @Override
    public boolean containsValue(TransactionLocal local, Transaction tx2) {
        TransactionLocalSynchronization sync = TransactionLocalDelegateImpl.getSynchronization(tx2, false);
        if (sync == null) {
            return false;
        }
        return sync.containsValue(local);
    }

    protected static class TransactionLocalSynchronization
    implements Synchronization {
        protected Transaction tx;
        private Map<Object, Object> valuesByLocal = Collections.synchronizedMap(new HashMap());
        protected ReentrantLock reentrantLock = new ReentrantLock();

        public TransactionLocalSynchronization(Transaction tx2) {
            this.tx = tx2;
        }

        @Override
        public void beforeCompletion() {
        }

        @Override
        public void afterCompletion(int status) {
            TransactionLocalDelegateImpl.removeSynchronization(this.tx);
            this.valuesByLocal.clear();
        }

        public void lock(Object local) throws InterruptedException {
            boolean locked = this.reentrantLock.tryLock(60000L, TimeUnit.MILLISECONDS);
            if (!locked) {
                throw new IllegalStateException("Failed to acquire lock within 60 seconds.");
            }
        }

        public void unlock(Object local) {
            this.reentrantLock.unlock();
        }

        public Object getValue(Object local) {
            return this.valuesByLocal.get(local);
        }

        public void setValue(Object local, Object value) {
            this.valuesByLocal.put(local, value);
        }

        public boolean containsValue(Object local) {
            return this.valuesByLocal.containsKey(local);
        }
    }
}

