/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.util.NullArgumentException;
import org.jboss.util.collection.AbstractQueue;
import org.jboss.util.collection.EmptyCollectionException;
import org.jboss.util.collection.ReverseListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListQueue<E>
extends AbstractQueue<E> {
    protected final List<E> list;

    public ListQueue(List<E> list2, int maxSize) {
        super(maxSize);
        if (list2 == null) {
            throw new NullArgumentException("list");
        }
        this.list = list2;
    }

    public ListQueue(int maxSize) {
        super(maxSize);
        this.list = new LinkedList();
    }

    public ListQueue(List<E> list2) {
        this(list2, -1);
    }

    public ListQueue() {
        this(new LinkedList(), -1);
    }

    @Override
    protected boolean addLast(E obj) {
        return this.list.add(obj);
    }

    @Override
    protected E removeFirst() {
        return this.list.remove(0);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public E getFront() throws EmptyCollectionException {
        if (this.isEmpty()) {
            throw new EmptyCollectionException();
        }
        return this.list.get(0);
    }

    @Override
    public E getBack() throws EmptyCollectionException {
        if (this.isEmpty()) {
            throw new EmptyCollectionException();
        }
        return this.list.get(this.list.size() - 1);
    }

    public Iterator<E> reverseIterator() {
        return new ReverseListIterator<E>(this.list);
    }

    @Override
    public String toString() {
        return this.list.toString();
    }
}

