/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Executing;
import org.jgroups.util.Util;

public class CENTRAL_EXECUTOR
extends Executing {
    @Property(description="Number of backups to the coordinator.  Queue State gets replicated to these nodes as well")
    protected int num_backups = 1;
    protected Address coord;
    @ManagedAttribute
    protected boolean is_coord;
    protected final List<Address> backups = new ArrayList<Address>();

    public Address getCoord() {
        return this.coord;
    }

    public boolean isCoord() {
        return this.is_coord;
    }

    @ManagedAttribute
    public String getCoordinator() {
        return this.coord != null ? this.coord.toString() : "n/a";
    }

    public int getNumberOfBackups() {
        return this.num_backups;
    }

    public void setNumberOfBackups(int num_backups) {
        this.num_backups = num_backups;
    }

    @ManagedAttribute
    public String getBackups() {
        return this.backups != null ? this.backups.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleView(View view) {
        Address oldCoord = this.coord;
        if (view.size() > 0) {
            this.coord = view.getMembers().iterator().next();
            this.is_coord = this.coord.equals(this.local_addr);
            if (this.log.isDebugEnabled()) {
                this.log.debug("local_addr=" + this.local_addr + ", coord=" + this.coord + ", is_coord=" + this.is_coord);
            }
        }
        if (oldCoord != this.coord) {
            for (Long requests : this._requestId.values()) {
                this.sendToCoordinator(Executing.Type.RUN_REQUEST, requests, this.local_addr);
            }
            for (Long requests : this._consumerId.keySet()) {
                this.sendToCoordinator(Executing.Type.CONSUMER_READY, requests, this.local_addr);
            }
        }
        if (this.num_backups > 0) {
            if (this.is_coord) {
                List<Address> new_backups = Util.pickNext(view.getMembers(), this.local_addr, this.num_backups);
                ArrayList<Address> new_members = null;
                List<Address> list2 = this.backups;
                synchronized (list2) {
                    if (!((Object)this.backups).equals(new_backups)) {
                        new_members = new ArrayList<Address>(new_backups);
                        new_members.removeAll(this.backups);
                        this.backups.clear();
                        this.backups.addAll(new_backups);
                    }
                }
                if (new_members != null && !new_members.isEmpty()) {
                    this.copyQueueTo(new_members);
                }
            } else {
                List<Address> possiblebackups = Util.pickNext(view.getMembers(), this.coord, this.num_backups);
                boolean foundMyself = false;
                ArrayList<Address> myBackups = new ArrayList<Address>();
                for (Address backup : possiblebackups) {
                    if (foundMyself) {
                        myBackups.add(backup);
                        continue;
                    }
                    if (!backup.equals(this.local_addr)) continue;
                    foundMyself = true;
                }
                List<Address> list3 = this.backups;
                synchronized (list3) {
                    this.backups.clear();
                    this.backups.addAll(myBackups);
                }
            }
        }
        super.handleView(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBackups(Executing.Type type, Executing.Owner obj) {
        List<Address> list2 = this.backups;
        synchronized (list2) {
            for (Address backup : this.backups) {
                this.sendRequest(backup, type, obj.getRequestId(), obj.getAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyQueueTo(List<Address> new_joiners) {
        HashSet copyConsumers;
        HashSet copyRequests;
        this._consumerLock.lock();
        try {
            copyRequests = new HashSet(this._runRequests);
            copyConsumers = new HashSet(this._consumersAvailable);
        }
        finally {
            this._consumerLock.unlock();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("copying queue to " + new_joiners);
        }
        for (Address joiner : new_joiners) {
            for (Executing.Owner address : copyRequests) {
                this.sendRequest(joiner, Executing.Type.CREATE_RUN_REQUEST, address.getRequestId(), address.getAddress());
            }
            for (Executing.Owner address : copyConsumers) {
                this.sendRequest(joiner, Executing.Type.CREATE_CONSUMER_READY, address.getRequestId(), address.getAddress());
            }
        }
    }

    @Override
    protected void sendToCoordinator(Executing.Type type, long requestId, Address value) {
        if (this.is_coord) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("[redirect] <--> [" + this.local_addr + "] " + type.name() + " [" + value + (requestId != -1L ? " request id: " + requestId : "") + "]");
            }
            switch (type) {
                case RUN_REQUEST: {
                    this.handleTaskRequest(requestId, value);
                    break;
                }
                case CONSUMER_READY: {
                    this.handleConsumerReadyRequest(requestId, value);
                    break;
                }
                case CONSUMER_UNREADY: {
                    this.handleConsumerUnreadyRequest(requestId, value);
                }
            }
        } else {
            this.sendRequest(this.coord, type, requestId, value);
        }
    }

    @Override
    protected void sendNewRunRequest(Executing.Owner sender) {
        if (this.is_coord) {
            this.updateBackups(Executing.Type.CREATE_RUN_REQUEST, sender);
        }
    }

    @Override
    protected void sendRemoveRunRequest(Executing.Owner sender) {
        if (this.is_coord) {
            this.updateBackups(Executing.Type.DELETE_RUN_REQUEST, sender);
        }
    }

    @Override
    protected void sendNewConsumerRequest(Executing.Owner sender) {
        if (this.is_coord) {
            this.updateBackups(Executing.Type.CREATE_CONSUMER_READY, sender);
        }
    }

    @Override
    protected void sendRemoveConsumerRequest(Executing.Owner sender) {
        if (this.is_coord) {
            this.updateBackups(Executing.Type.DELETE_CONSUMER_READY, sender);
        }
    }
}

