/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.util.Util;

public class ParseMessages {
    InputStream input = null;
    private static final byte LIST = 1;
    private static final byte MULTICAST = 2;

    public ParseMessages(String input) throws FileNotFoundException {
        this.input = new FileInputStream(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(this.input);
            block6: while (true) {
                boolean multicast;
                short version;
                try {
                    version = dis.readShort();
                }
                catch (IOException io_ex) {
                    break;
                }
                System.out.println("version = " + version + " (" + Version.print(version) + ")");
                byte flags = dis.readByte();
                System.out.println("flags: " + Message.flagsToString(flags));
                boolean is_message_list = (flags & 1) == 1;
                boolean bl = multicast = (flags & 2) == 2;
                if (is_message_list) {
                    List<Message> msgs = ParseMessages.readMessageList(dis);
                    System.out.println(msgs.size() + " msgs: ");
                    int cnt = 1;
                    Iterator<Message> i$ = msgs.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block6;
                        Message msg = i$.next();
                        System.out.print("#" + cnt++ + ": ");
                        ParseMessages.print(msg, multicast);
                    }
                }
                Message msg = ParseMessages.readMessage(dis);
                ParseMessages.print(msg, multicast);
            }
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                Util.close(dis);
                throw throwable;
            }
            Util.close(dis);
        }
        Util.close(dis);
    }

    private static void print(Message msg, boolean multicast) {
        System.out.println(msg + ", hdrs: " + msg.printHeaders() + ", mcast: " + multicast);
    }

    private static List<Message> readMessageList(DataInputStream in) throws Exception {
        LinkedList<Message> list2 = new LinkedList<Message>();
        Address dest = Util.readAddress(in);
        Address src = Util.readAddress(in);
        while (in.readBoolean()) {
            Message msg = new Message(false);
            msg.readFrom(in);
            msg.setDest(dest);
            if (msg.getSrc() == null) {
                msg.setSrc(src);
            }
            list2.add(msg);
        }
        return list2;
    }

    protected static Message readMessage(DataInputStream instream) throws Exception {
        Message msg = new Message(false);
        msg.readFrom(instream);
        return msg;
    }

    public static void main(String[] args) throws FileNotFoundException {
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-file")) {
                ParseMessages.help();
                return;
            }
            file = args[++i];
        }
        new ParseMessages(file).parse();
    }

    private static void help() {
        System.out.println("ParseMessages [-file <filename>]");
    }
}

