/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Results;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Booleans {
    private Booleans() {
    }

    public static boolean isFalsy(Object value) {
        if (value == null || Results.Result.NOT_FOUND.equals(value)) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof AtomicBoolean) {
            return !((AtomicBoolean)value).get();
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() == 0;
        }
        if (value instanceof Number) {
            return Booleans.isZero((Number)value);
        }
        return false;
    }

    private static boolean isZero(Number number) {
        if (number instanceof BigDecimal) {
            return BigDecimal.ZERO.compareTo((BigDecimal)number) == 0;
        }
        if (number instanceof BigInteger) {
            return BigInteger.ZERO.equals(number);
        }
        if (number instanceof Float || number instanceof Double) {
            return number.doubleValue() == 0.0;
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            return number.longValue() == 0L;
        }
        return BigDecimal.ZERO.compareTo(new BigDecimal(number.toString())) == 0;
    }
}

