/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Evaluator;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.Futures;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.Results;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.ValueResolver;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

class EvaluatorImpl
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger(EvaluatorImpl.class);
    private final List<ValueResolver> resolvers;

    EvaluatorImpl(List<ValueResolver> valueResolvers) {
        this.resolvers = valueResolvers;
    }

    @Override
    public CompletionStage<Object> evaluate(Expression expression, ResolutionContext resolutionContext) {
        if (expression.hasNamespace()) {
            Iterator<Expression.Part> parts = expression.getParts().iterator();
            NamespaceResolver resolver = this.findNamespaceResolver(expression.getNamespace(), resolutionContext);
            if (resolver == null) {
                LOGGER.errorf("No namespace resolver found for: %s", (Object)expression.getNamespace());
                return Futures.failure(new TemplateException("No resolver for namespace: " + expression.getNamespace()));
            }
            EvalContextImpl context = new EvalContextImpl(false, null, parts.next(), resolutionContext);
            LOGGER.debugf("Found '%s' namespace resolver: %s", (Object)expression.getNamespace(), (Object)resolver.getClass());
            return resolver.resolve(context).thenCompose(r -> {
                if (parts.hasNext()) {
                    return this.resolveReference(false, r, parts, resolutionContext);
                }
                return CompletableFuture.completedFuture(r);
            });
        }
        if (expression.isLiteral()) {
            return expression.getLiteralValue();
        }
        Iterator<Expression.Part> parts = expression.getParts().iterator();
        return this.resolveReference(true, resolutionContext.getData(), parts, resolutionContext);
    }

    private NamespaceResolver findNamespaceResolver(String namespace, ResolutionContext resolutionContext) {
        if (resolutionContext == null) {
            return null;
        }
        if (resolutionContext.getNamespaceResolvers() != null) {
            for (NamespaceResolver resolver : resolutionContext.getNamespaceResolvers()) {
                if (!resolver.getNamespace().equals(namespace)) continue;
                return resolver;
            }
        }
        return this.findNamespaceResolver(namespace, resolutionContext.getParent());
    }

    private CompletionStage<Object> resolveReference(boolean tryParent, Object ref, Iterator<Expression.Part> parts, ResolutionContext resolutionContext) {
        Expression.Part part = parts.next();
        EvalContextImpl evalContext = new EvalContextImpl(tryParent, ref, part, resolutionContext);
        if (!parts.hasNext()) {
            return this.resolve(evalContext, this.resolvers.iterator());
        }
        return this.resolve(evalContext, this.resolvers.iterator()).thenCompose(r -> this.resolveReference(false, r, parts, resolutionContext));
    }

    private CompletionStage<Object> resolve(EvalContextImpl evalContext, Iterator<ValueResolver> resolvers) {
        if (!resolvers.hasNext()) {
            ResolutionContext parent = evalContext.resolutionContext.getParent();
            if (evalContext.tryParent && parent != null) {
                return this.resolve(new EvalContextImpl(true, parent.getData(), evalContext.name, evalContext.params, parent), this.resolvers.iterator());
            }
            LOGGER.tracef("Unable to resolve %s", (Object)evalContext);
            return Results.NOT_FOUND;
        }
        ValueResolver resolver = resolvers.next();
        if (resolver.appliesTo(evalContext)) {
            return resolver.resolve(evalContext).thenCompose(r -> {
                if (Results.Result.NOT_FOUND.equals(r)) {
                    return this.resolve(evalContext, resolvers);
                }
                return CompletableFuture.completedFuture(r);
            });
        }
        return this.resolve(evalContext, resolvers);
    }

    static class EvalContextImpl
    implements EvalContext {
        final boolean tryParent;
        final Object base;
        final String name;
        final List<Expression> params;
        final ResolutionContext resolutionContext;

        EvalContextImpl(boolean tryParent, Object base, Expression.Part part, ResolutionContext resolutionContext) {
            this(tryParent, base, part.getName(), part.isVirtualMethod() ? part.asVirtualMethod().getParameters() : Collections.emptyList(), resolutionContext);
        }

        EvalContextImpl(boolean tryParent, Object base, String name, List<Expression> params, ResolutionContext resolutionContext) {
            this.tryParent = tryParent;
            this.base = base;
            this.resolutionContext = resolutionContext;
            this.params = params;
            this.name = name;
        }

        @Override
        public Object getBase() {
            return this.base;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<Expression> getParams() {
            return this.params;
        }

        @Override
        public CompletionStage<Object> evaluate(String value) {
            return this.evaluate(ExpressionImpl.from(value));
        }

        @Override
        public CompletionStage<Object> evaluate(Expression expression) {
            return this.resolutionContext.evaluate(expression);
        }

        @Override
        public Object getAttribute(String key) {
            return this.resolutionContext.getAttribute(key);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EvalContextImpl [tryParent=").append(this.tryParent).append(", base=").append(this.base).append(", name=").append(this.name).append(", params=").append(this.params).append("]");
            return builder.toString();
        }
    }
}

