/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ExpressionNode;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.ResultNode;
import java.util.List;
import java.util.function.Consumer;

public class SingleResultNode
implements ResultNode {
    private final Object value;
    private final ExpressionImpl expression;
    private final List<ResultMapper> mappers;

    public SingleResultNode(Object value, ExpressionNode expressionNode) {
        this.value = value;
        this.mappers = expressionNode.getEngine().getResultMappers().isEmpty() ? null : expressionNode.getEngine().getResultMappers();
        this.expression = this.mappers != null ? expressionNode.expression : null;
    }

    @Override
    public void process(Consumer<String> consumer) {
        if (this.value != null) {
            String result = null;
            if (this.mappers != null) {
                for (ResultMapper mapper : this.mappers) {
                    if (!mapper.appliesTo(this.expression.getOrigin(), this.value)) continue;
                    result = mapper.map(this.value, this.expression);
                    break;
                }
            }
            if (result == null) {
                result = this.value.toString();
            }
            consumer.accept(result);
        }
    }
}

