/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.time.Duration;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class UniBlockingAwait {
    private UniBlockingAwait() {
    }

    public static <T> T await(Uni<T> upstream, Duration duration) {
        ParameterValidation.nonNull(upstream, "upstream");
        UniBlockingAwait.validate(duration);
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference reference = new AtomicReference();
        final AtomicReference<Exception> referenceToFailure = new AtomicReference<Exception>();
        UniSubscriber subscriber = new UniSubscriber<T>(){

            @Override
            public void onSubscribe(UniSubscription subscription) {
            }

            @Override
            public void onItem(T item) {
                reference.set(item);
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable failure) {
                referenceToFailure.compareAndSet(null, failure);
                latch.countDown();
            }
        };
        AbstractUni.subscribe(upstream, subscriber);
        try {
            if (duration != null) {
                if (!latch.await(duration.toMillis(), TimeUnit.MILLISECONDS)) {
                    referenceToFailure.compareAndSet(null, new TimeoutException());
                }
            } else {
                latch.await();
            }
        }
        catch (InterruptedException e) {
            referenceToFailure.compareAndSet(null, e);
            Thread.currentThread().interrupt();
        }
        Throwable throwable = (Throwable)referenceToFailure.get();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new CompletionException(throwable);
        }
        return (T)reference.get();
    }

    private static void validate(Duration duration) {
        if (duration == null) {
            return;
        }
        if (duration.isZero() || duration.isNegative()) {
            throw new IllegalArgumentException("`duration` must be greater than zero");
        }
    }
}

