/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.BiFunction;

public final class MultiScanOp<T>
extends AbstractMultiOperator<T, T> {
    private final BiFunction<T, ? super T, T> accumulator;

    public MultiScanOp(Multi<? extends T> upstream, BiFunction<T, ? super T, T> accumulator) {
        super(upstream);
        this.accumulator = ParameterValidation.nonNull(accumulator, "accumulator");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new ScanProcessor<T>(downstream, this.accumulator));
    }

    static final class ScanProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final BiFunction<T, ? super T, T> accumulator;
        private T current;

        ScanProcessor(MultiSubscriber<? super T> downstream, BiFunction<T, ? super T, T> accumulator) {
            super(downstream);
            this.accumulator = accumulator;
        }

        @Override
        public void onItem(T item) {
            if (this.isDone()) {
                return;
            }
            T result = item;
            if (this.current != null) {
                try {
                    result = this.accumulator.apply(this.current, item);
                }
                catch (Throwable e) {
                    this.onFailure(e);
                    return;
                }
                if (result == null) {
                    this.onFailure(new NullPointerException("The mapper returned `null`"));
                    return;
                }
            }
            this.current = result;
            this.downstream.onItem(item);
        }

        @Override
        public void onFailure(Throwable failure) {
            super.onFailure(failure);
            this.current = null;
        }

        @Override
        public void onCompletion() {
            super.onCompletion();
            this.current = null;
        }
    }
}

