/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Parameter;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.TemplateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public interface SectionHelperFactory<T extends SectionHelper> {
    public static final String MAIN_BLOCK_NAME = "$main";

    default public List<String> getDefaultAliases() {
        return Collections.emptyList();
    }

    default public ParametersInfo getParameters() {
        return ParametersInfo.EMPTY;
    }

    default public List<String> getBlockLabels() {
        return Collections.emptyList();
    }

    default public boolean treatUnknownSectionsAsBlocks() {
        return false;
    }

    public T initialize(SectionInitContext var1);

    default public Map<String, String> initializeBlock(Map<String, String> outerNameTypeInfos, BlockInfo block) {
        return Collections.emptyMap();
    }

    public static final class ParametersInfo
    implements Iterable<List<Parameter>> {
        public static final ParametersInfo EMPTY = ParametersInfo.builder().build();
        private final Map<String, List<Parameter>> parameters;

        public static Builder builder() {
            return new Builder();
        }

        private ParametersInfo(Map<String, List<Parameter>> parameters) {
            this.parameters = new HashMap<String, List<Parameter>>(parameters);
        }

        public List<Parameter> get(String sectionPart) {
            return this.parameters.getOrDefault(sectionPart, Collections.emptyList());
        }

        @Override
        public Iterator<List<Parameter>> iterator() {
            return this.parameters.values().iterator();
        }

        public static class Builder {
            private final Map<String, List<Parameter>> parameters = new HashMap<String, List<Parameter>>();

            Builder() {
            }

            public Builder addParameter(String name) {
                return this.addParameter(SectionHelperFactory.MAIN_BLOCK_NAME, name, null);
            }

            public Builder addParameter(String name, String defaultValue) {
                return this.addParameter(SectionHelperFactory.MAIN_BLOCK_NAME, name, defaultValue);
            }

            public Builder addParameter(Parameter param) {
                return this.addParameter(SectionHelperFactory.MAIN_BLOCK_NAME, param);
            }

            public Builder addParameter(String blockLabel, String name, String defaultValue) {
                return this.addParameter(blockLabel, new Parameter(name, defaultValue, false));
            }

            public Builder addParameter(String blockLabel, Parameter parameter) {
                this.parameters.computeIfAbsent(blockLabel, c -> new ArrayList()).add(parameter);
                return this;
            }

            public ParametersInfo build() {
                return new ParametersInfo(this.parameters);
            }
        }
    }

    public static interface SectionInitContext
    extends ParserDelegate {
        default public Map<String, String> getParameters() {
            return this.getBlocks().get((int)0).parameters;
        }

        default public boolean hasParameter(String name) {
            return this.getParameters().containsKey(name);
        }

        default public String getParameter(String name) {
            return this.getParameters().get(name);
        }

        public Expression getExpression(String var1);

        public Expression parseValue(String var1);

        public List<SectionBlock> getBlocks();

        public Engine getEngine();
    }

    public static interface BlockInfo
    extends ParserDelegate {
        public String getLabel();

        public Map<String, String> getParameters();

        default public String getParameter(String name) {
            return this.getParameters().get(name);
        }

        default public boolean hasParameter(String name) {
            return this.getParameters().containsKey(name);
        }

        public Expression addExpression(String var1, String var2);
    }

    public static interface ParserDelegate {
        public TemplateException createParserError(String var1);
    }
}

