/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.AbstractDelegatingConfigSource;
import io.quarkus.runtime.configuration.ProfileManager;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.wildfly.common.Assert;

public class DeploymentProfileConfigSource
extends AbstractDelegatingConfigSource {
    private static final long serialVersionUID = -8001338475089294128L;
    private final String profilePrefix;

    public static UnaryOperator<ConfigSource> wrapper() {
        return new UnaryOperator<ConfigSource>(){

            @Override
            public ConfigSource apply(ConfigSource configSource) {
                return new DeploymentProfileConfigSource(configSource, ProfileManager.getActiveProfile());
            }
        };
    }

    public DeploymentProfileConfigSource(ConfigSource delegate, String profileName) {
        super(delegate);
        Assert.checkNotNullParam("profileName", profileName);
        this.profilePrefix = "%" + profileName + ".";
    }

    Object writeReplace() throws ObjectStreamException {
        return new Ser(this.delegate, this.profilePrefix);
    }

    @Override
    public Set<String> getPropertyNames() {
        Set<String> propertyNames = this.delegate.getPropertyNames();
        HashSet<String> ret = new HashSet<String>(propertyNames);
        for (String i : propertyNames) {
            if (!i.startsWith(this.profilePrefix)) continue;
            ret.add(i.substring(this.profilePrefix.length()));
        }
        return ret;
    }

    @Override
    public String getValue(String name) {
        String nameWithProfile;
        ConfigSource delegate = this.getDelegate();
        String result = delegate.getValue(nameWithProfile = this.profilePrefix + name);
        if (result != null) {
            return result;
        }
        return delegate.getValue(name);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String toString() {
        return "DeploymentProfileConfigSource[profile=" + this.profilePrefix + ",delegate=" + this.getDelegate() + ",ord=" + this.getOrdinal() + "]";
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = -4618790131794331510L;
        final ConfigSource d;
        final String p;

        Ser(ConfigSource d, String p) {
            this.d = d;
            this.p = p;
        }

        Object readResolve() {
            return new DeploymentProfileConfigSource(this.d, this.p);
        }
    }
}

