/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.io.PrintWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.PropertyValues;
import org.jboss.logmanager.formatters.StringBuilderWriter;

public abstract class StructuredFormatter
extends ExtFormatter {
    private final Map<Key, String> keyOverrides;
    private final String keyOverridesValue;
    private volatile boolean printDetails;
    private volatile String eorDelimiter = "\n";
    private DateTimeFormatter dateTimeFormatter;
    private ZoneId zoneId;
    private volatile ExceptionOutputType exceptionOutputType;
    private final StringBuilderWriter writer = new StringBuilderWriter();
    private int refId;

    protected StructuredFormatter() {
        this(null, null);
    }

    protected StructuredFormatter(Map<Key, String> keyOverrides) {
        this(keyOverrides, PropertyValues.mapToString(keyOverrides));
    }

    protected StructuredFormatter(String keyOverrides) {
        this(PropertyValues.stringToEnumMap(Key.class, keyOverrides), keyOverrides);
    }

    private StructuredFormatter(Map<Key, String> keyOverrides, String keyOverridesValue) {
        this.keyOverridesValue = keyOverridesValue;
        this.printDetails = false;
        this.zoneId = ZoneId.systemDefault();
        this.dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(this.zoneId);
        this.keyOverrides = keyOverrides == null ? Collections.emptyMap() : new EnumMap<Key, String>(keyOverrides);
        this.exceptionOutputType = ExceptionOutputType.DETAILED;
    }

    protected abstract Generator createGenerator(Writer var1) throws Exception;

    protected void before(Generator generator, ExtLogRecord record) throws Exception {
    }

    protected void after(Generator generator, ExtLogRecord record) throws Exception {
    }

    protected final String getKey(Key defaultKey) {
        if (this.keyOverrides.containsKey((Object)defaultKey)) {
            return this.keyOverrides.get((Object)defaultKey);
        }
        return defaultKey.getKey();
    }

    @Override
    public final synchronized String format(ExtLogRecord record) {
        boolean details = this.printDetails;
        try {
            Throwable thrown;
            long processId;
            Generator generator = this.createGenerator(this.writer).begin();
            this.before(generator, record);
            generator.add(this.getKey(Key.TIMESTAMP), this.dateTimeFormatter.format(Instant.ofEpochMilli(record.getMillis()))).add(this.getKey(Key.SEQUENCE), record.getSequenceNumber()).add(this.getKey(Key.LOGGER_CLASS_NAME), record.getLoggerClassName()).add(this.getKey(Key.LOGGER_NAME), record.getLoggerName()).add(this.getKey(Key.LEVEL), record.getLevel().getName()).add(this.getKey(Key.MESSAGE), this.formatMessage(record)).add(this.getKey(Key.THREAD_NAME), record.getThreadName()).add(this.getKey(Key.THREAD_ID), record.getThreadID()).add(this.getKey(Key.MDC), record.getMdcCopy()).add(this.getKey(Key.NDC), record.getNdc());
            if (StructuredFormatter.isNotNullOrEmpty(record.getHostName())) {
                generator.add(this.getKey(Key.HOST_NAME), record.getHostName());
            }
            if (StructuredFormatter.isNotNullOrEmpty(record.getProcessName())) {
                generator.add(this.getKey(Key.PROCESS_NAME), record.getProcessName());
            }
            if ((processId = record.getProcessId()) >= 0L) {
                generator.add(this.getKey(Key.PROCESS_ID), record.getProcessId());
            }
            if ((thrown = record.getThrown()) != null) {
                if (this.isDetailedExceptionOutputType()) {
                    this.refId = 0;
                    IdentityHashMap<Throwable, Integer> seen = new IdentityHashMap<Throwable, Integer>();
                    generator.startObject(this.getKey(Key.EXCEPTION));
                    this.addException(generator, thrown, seen);
                    generator.endObject();
                }
                if (this.isFormattedExceptionOutputType()) {
                    StringBuilderWriter w = new StringBuilderWriter();
                    thrown.printStackTrace(new PrintWriter(w));
                    generator.add(this.getKey(Key.STACK_TRACE), w.toString());
                }
            }
            if (details) {
                generator.add(this.getKey(Key.SOURCE_CLASS_NAME), record.getSourceClassName()).add(this.getKey(Key.SOURCE_FILE_NAME), record.getSourceFileName()).add(this.getKey(Key.SOURCE_METHOD_NAME), record.getSourceMethodName()).add(this.getKey(Key.SOURCE_LINE_NUMBER), record.getSourceLineNumber()).add(this.getKey(Key.SOURCE_MODULE_NAME), record.getSourceModuleName()).add(this.getKey(Key.SOURCE_MODULE_VERSION), record.getSourceModuleVersion());
            }
            this.after(generator, record);
            generator.end();
            if (this.getRecordDelimiter() != null) {
                this.writer.append(this.getRecordDelimiter());
            }
            String string = this.writer.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writer.clear();
        }
    }

    @Override
    public boolean isCallerCalculationRequired() {
        return this.isPrintDetails();
    }

    public String getKeyOverrides() {
        return this.keyOverridesValue;
    }

    public String getRecordDelimiter() {
        return this.eorDelimiter;
    }

    public void setRecordDelimiter(String eorDelimiter) {
        this.eorDelimiter = eorDelimiter;
    }

    public synchronized DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public synchronized void setDateFormat(String pattern) {
        this.dateTimeFormatter = pattern == null ? DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(this.zoneId) : DateTimeFormatter.ofPattern(pattern).withZone(this.zoneId);
    }

    public synchronized ZoneId getZoneId() {
        return this.zoneId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoneId(String zoneId) {
        ZoneId changed = zoneId == null ? ZoneId.systemDefault() : ZoneId.of(zoneId);
        StructuredFormatter structuredFormatter = this;
        synchronized (structuredFormatter) {
            this.zoneId = changed;
            this.dateTimeFormatter = this.dateTimeFormatter.withZone(changed);
        }
    }

    public boolean isPrintDetails() {
        return this.printDetails;
    }

    public void setPrintDetails(boolean printDetails) {
        this.printDetails = printDetails;
    }

    public ExceptionOutputType getExceptionOutputType() {
        return this.exceptionOutputType;
    }

    public void setExceptionOutputType(ExceptionOutputType exceptionOutputType) {
        this.exceptionOutputType = exceptionOutputType == null ? ExceptionOutputType.DETAILED : exceptionOutputType;
    }

    protected boolean isDetailedExceptionOutputType() {
        ExceptionOutputType exceptionOutputType = this.exceptionOutputType;
        return exceptionOutputType == ExceptionOutputType.DETAILED || exceptionOutputType == ExceptionOutputType.DETAILED_AND_FORMATTED;
    }

    protected boolean isFormattedExceptionOutputType() {
        ExceptionOutputType exceptionOutputType = this.exceptionOutputType;
        return exceptionOutputType == ExceptionOutputType.FORMATTED || exceptionOutputType == ExceptionOutputType.DETAILED_AND_FORMATTED;
    }

    private void addException(Generator generator, Throwable throwable, Map<Throwable, Integer> seen) throws Exception {
        if (throwable == null) {
            return;
        }
        if (seen.containsKey(throwable)) {
            generator.addAttribute(this.getKey(Key.EXCEPTION_REFERENCE_ID), seen.get(throwable));
            generator.startObject(this.getKey(Key.EXCEPTION_CIRCULAR_REFERENCE));
            generator.add(this.getKey(Key.EXCEPTION_MESSAGE), throwable.getMessage());
            generator.endObject();
        } else {
            Throwable cause;
            int id = ++this.refId;
            seen.put(throwable, id);
            generator.addAttribute(this.getKey(Key.EXCEPTION_REFERENCE_ID), id);
            generator.add(this.getKey(Key.EXCEPTION_TYPE), throwable.getClass().getName());
            generator.add(this.getKey(Key.EXCEPTION_MESSAGE), throwable.getMessage());
            StackTraceElement[] elements = throwable.getStackTrace();
            this.addStackTraceElements(generator, elements);
            Throwable[] suppressed = throwable.getSuppressed();
            if (suppressed != null && suppressed.length > 0) {
                generator.startArray(this.getKey(Key.EXCEPTION_SUPPRESSED));
                for (Throwable s : suppressed) {
                    if (generator.wrapArrays()) {
                        generator.startObject(this.getKey(Key.EXCEPTION));
                    } else {
                        generator.startObject(null);
                    }
                    this.addException(generator, s, seen);
                    generator.endObject();
                }
                generator.endArray();
            }
            if ((cause = throwable.getCause()) != null) {
                generator.startObject(this.getKey(Key.EXCEPTION_CAUSED_BY));
                generator.startObject(this.getKey(Key.EXCEPTION));
                this.addException(generator, cause, seen);
                generator.endObject();
                generator.endObject();
            }
        }
    }

    private void addStackTraceElements(Generator generator, StackTraceElement[] elements) throws Exception {
        generator.startArray(this.getKey(Key.EXCEPTION_FRAMES));
        for (StackTraceElement e : elements) {
            if (generator.wrapArrays()) {
                generator.startObject(this.getKey(Key.EXCEPTION_FRAME));
            } else {
                generator.startObject(null);
            }
            generator.add(this.getKey(Key.EXCEPTION_FRAME_CLASS), e.getClassName());
            generator.add(this.getKey(Key.EXCEPTION_FRAME_METHOD), e.getMethodName());
            int line = e.getLineNumber();
            if (line >= 0) {
                generator.add(this.getKey(Key.EXCEPTION_FRAME_LINE), e.getLineNumber());
            }
            generator.endObject();
        }
        generator.endArray();
    }

    private static boolean isNotNullOrEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    private static boolean isNotNullOrEmpty(Collection<?> value) {
        return value != null && !value.isEmpty();
    }

    protected static interface Generator {
        default public Generator begin() throws Exception {
            return this;
        }

        default public Generator add(String key, int value) throws Exception {
            this.add(key, Integer.toString(value));
            return this;
        }

        default public Generator add(String key, long value) throws Exception {
            this.add(key, Long.toString(value));
            return this;
        }

        public Generator add(String var1, Map<String, ?> var2) throws Exception;

        public Generator add(String var1, String var2) throws Exception;

        default public Generator addMetaData(Map<String, String> metaData) throws Exception {
            for (String key : metaData.keySet()) {
                this.add(key, metaData.get(key));
            }
            return this;
        }

        public Generator startObject(String var1) throws Exception;

        public Generator endObject() throws Exception;

        default public Generator startArray(String key) throws Exception {
            return this.startObject(key);
        }

        default public Generator endArray() throws Exception {
            return this.endObject();
        }

        default public Generator addAttribute(String name, int value) throws Exception {
            return this.add(name, value);
        }

        default public Generator addAttribute(String name, String value) throws Exception {
            return this.add(name, value);
        }

        public Generator end() throws Exception;

        default public boolean wrapArrays() {
            return false;
        }
    }

    public static enum ExceptionOutputType {
        DETAILED,
        FORMATTED,
        DETAILED_AND_FORMATTED;

    }

    public static enum Key {
        EXCEPTION("exception"),
        EXCEPTION_CAUSED_BY("causedBy"),
        EXCEPTION_CIRCULAR_REFERENCE("circularReference"),
        EXCEPTION_TYPE("exceptionType"),
        EXCEPTION_FRAME("frame"),
        EXCEPTION_FRAME_CLASS("class"),
        EXCEPTION_FRAME_LINE("line"),
        EXCEPTION_FRAME_METHOD("method"),
        EXCEPTION_FRAMES("frames"),
        EXCEPTION_MESSAGE("message"),
        EXCEPTION_REFERENCE_ID("refId"),
        EXCEPTION_SUPPRESSED("suppressed"),
        HOST_NAME("hostName"),
        LEVEL("level"),
        LOGGER_CLASS_NAME("loggerClassName"),
        LOGGER_NAME("loggerName"),
        MDC("mdc"),
        MESSAGE("message"),
        NDC("ndc"),
        PROCESS_ID("processId"),
        PROCESS_NAME("processName"),
        RECORD("record"),
        SEQUENCE("sequence"),
        SOURCE_CLASS_NAME("sourceClassName"),
        SOURCE_FILE_NAME("sourceFileName"),
        SOURCE_LINE_NUMBER("sourceLineNumber"),
        SOURCE_METHOD_NAME("sourceMethodName"),
        SOURCE_MODULE_NAME("sourceModuleName"),
        SOURCE_MODULE_VERSION("sourceModuleVersion"),
        STACK_TRACE("stackTrace"),
        THREAD_ID("threadId"),
        THREAD_NAME("threadName"),
        TIMESTAMP("timestamp");

        private final String key;

        private Key(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

