/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscription;

public class CollectionBasedMulti<T>
extends AbstractMulti<T> {
    private final Collection<T> collection;

    @SafeVarargs
    public CollectionBasedMulti(T ... array) {
        this.collection = Arrays.asList(ParameterValidation.doesNotContainNull(array, "array"));
    }

    public CollectionBasedMulti(Collection<T> collection) {
        this.collection = Collections.unmodifiableCollection(ParameterValidation.doesNotContainNull(collection, "collection"));
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        ParameterValidation.nonNullNpe(actual, "subscriber");
        if (this.collection.isEmpty()) {
            Subscriptions.complete(actual);
            return;
        }
        actual.onSubscribe(new CollectionSubscription<T>(actual, this.collection));
    }

    public static final class CollectionSubscription<T>
    implements Subscription {
        private final MultiSubscriber<? super T> downstream;
        private final List<T> collection;
        private int index;
        AtomicBoolean cancelled = new AtomicBoolean();
        AtomicLong requested = new AtomicLong();

        public CollectionSubscription(MultiSubscriber<? super T> downstream, Collection<T> collection) {
            this.downstream = downstream;
            this.collection = new ArrayList<T>(collection);
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                if (Subscriptions.add(this.requested, n) == 0L) {
                    if (n == Long.MAX_VALUE) {
                        this.produceWithoutBackPressure();
                    } else {
                        this.followRequests(n);
                    }
                }
            } else {
                this.downstream.onFailure(Subscriptions.getInvalidRequestException());
            }
        }

        void followRequests(long n) {
            List<T> items = this.collection;
            int size = items.size();
            int current = this.index;
            int emitted = 0;
            while (!this.cancelled.get()) {
                while (current != size && (long)emitted != n) {
                    this.downstream.onItem(items.get(current));
                    if (this.cancelled.get()) {
                        return;
                    }
                    ++current;
                    ++emitted;
                }
                if (current == size) {
                    this.downstream.onCompletion();
                    return;
                }
                n = this.requested.get();
                if (n != (long)emitted) continue;
                this.index = current;
                n = this.requested.addAndGet(-emitted);
                if (n == 0L) {
                    return;
                }
                emitted = 0;
            }
            return;
        }

        void produceWithoutBackPressure() {
            for (T item : this.collection) {
                if (this.cancelled.get()) {
                    return;
                }
                this.downstream.onItem(item);
            }
            if (this.cancelled.get()) {
                return;
            }
            this.downstream.onCompletion();
        }

        @Override
        public void cancel() {
            this.cancelled.set(true);
        }
    }
}

