/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Shorts;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractShortAssert<SELF extends AbstractShortAssert<SELF>>
extends AbstractComparableAssert<SELF, Short>
implements NumberAssert<SELF, Short> {
    @VisibleForTesting
    Shorts shorts = Shorts.instance();

    public AbstractShortAssert(Short actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isEqualTo(short expected) {
        this.shorts.assertEqual(this.info, (Short)this.actual, expected);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    public SELF isNotEqualTo(short other) {
        this.shorts.assertNotEqual(this.info, (Short)this.actual, other);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isZero() {
        this.shorts.assertIsZero(this.info, (Short)this.actual);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        this.shorts.assertIsNotZero(this.info, (Short)this.actual);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.shorts.assertIsOne(this.info, (Short)this.actual);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.shorts.assertIsPositive(this.info, (Short)this.actual);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.shorts.assertIsNegative(this.info, (Short)this.actual);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.shorts.assertIsNotNegative(this.info, (Short)this.actual);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.shorts.assertIsNotPositive(this.info, (Short)this.actual);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isLessThan(short other) {
        this.shorts.assertLessThan(this.info, (Short)this.actual, other);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(short other) {
        this.shorts.assertLessThanOrEqualTo(this.info, (Short)this.actual, other);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(short other) {
        this.shorts.assertGreaterThan(this.info, (Short)this.actual, other);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(short other) {
        this.shorts.assertGreaterThanOrEqualTo(this.info, (Short)this.actual, other);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isBetween(Short start, Short end) {
        this.shorts.assertIsBetween(this.info, (Short)this.actual, start, end);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(Short start, Short end) {
        this.shorts.assertIsStrictlyBetween(this.info, (Short)this.actual, start, end);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(short expected, Offset<Short> offset) {
        this.shorts.assertIsCloseTo(this.info, (Short)this.actual, expected, offset);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(short expected, Offset<Short> offset) {
        this.shorts.assertIsNotCloseTo(this.info, (Short)this.actual, expected, offset);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Short expected, Offset<Short> offset) {
        this.shorts.assertIsCloseTo(this.info, (Short)this.actual, expected, offset);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Short expected, Offset<Short> offset) {
        this.shorts.assertIsNotCloseTo(this.info, (Short)this.actual, expected, offset);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Short expected, Percentage percentage) {
        this.shorts.assertIsCloseToPercentage(this.info, (Short)this.actual, expected, percentage);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Short expected, Percentage percentage) {
        this.shorts.assertIsNotCloseToPercentage(this.info, (Short)this.actual, expected, percentage);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(short expected, Percentage percentage) {
        this.shorts.assertIsCloseToPercentage(this.info, (Short)this.actual, expected, percentage);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(short expected, Percentage percentage) {
        this.shorts.assertIsNotCloseToPercentage(this.info, (Short)this.actual, expected, percentage);
        return (SELF)((AbstractShortAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Short> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Short> customComparator, String customComparatorDescription) {
        this.shorts = new Shorts(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractShortAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.shorts = Shorts.instance();
        return (SELF)((AbstractShortAssert)super.usingDefaultComparator());
    }
}

