/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.FastCopyHashMap;
import org.jboss.logmanager.JDKSpecific;
import org.jboss.logmanager.MDC;
import org.jboss.logmanager.NDC;
import org.jboss.logmanager.WrappedExtLogRecord;
import org.wildfly.common.net.HostName;
import org.wildfly.common.os.Process;

public class ExtLogRecord
extends LogRecord {
    private static final long serialVersionUID = -9174374711278052369L;
    private final transient String loggerClassName;
    private transient boolean calculateCaller = true;
    private String ndc;
    private FormatStyle formatStyle = FormatStyle.MESSAGE_FORMAT;
    private FastCopyHashMap<String, Object> mdcCopy;
    private int sourceLineNumber = -1;
    private String sourceFileName;
    private String threadName;
    private String hostName;
    private String processName;
    private long processId = -1L;
    private String sourceModuleName;
    private String sourceModuleVersion;

    public ExtLogRecord(Level level, String msg, String loggerClassName) {
        this(level, msg, FormatStyle.MESSAGE_FORMAT, loggerClassName);
    }

    public ExtLogRecord(Level level, String msg, FormatStyle formatStyle, String loggerClassName) {
        super(level, msg);
        this.formatStyle = formatStyle == null ? FormatStyle.MESSAGE_FORMAT : formatStyle;
        this.loggerClassName = loggerClassName;
        this.ndc = NDC.get();
        this.threadName = Thread.currentThread().getName();
        this.hostName = HostName.getQualifiedHostName();
        this.processName = Process.getProcessName();
        this.processId = Process.getProcessId();
    }

    public ExtLogRecord(ExtLogRecord original) {
        super(original.getLevel(), original.getMessage());
        this.setLoggerName(original.getLoggerName());
        this.setMillis(original.getMillis());
        this.setParameters(original.getParameters());
        this.setResourceBundle(original.getResourceBundle());
        this.setResourceBundleName(original.getResourceBundleName());
        this.setSequenceNumber(original.getSequenceNumber());
        this.setThreadID(original.getThreadID());
        this.setThrown(original.getThrown());
        if (!original.calculateCaller) {
            this.setSourceClassName(original.getSourceClassName());
            this.setSourceMethodName(original.getSourceMethodName());
            this.sourceFileName = original.sourceFileName;
            this.sourceLineNumber = original.sourceLineNumber;
            this.sourceModuleName = original.sourceModuleName;
            this.sourceModuleVersion = original.sourceModuleVersion;
        }
        this.formatStyle = original.formatStyle;
        this.mdcCopy = original.mdcCopy;
        this.ndc = original.ndc;
        this.loggerClassName = original.loggerClassName;
        this.threadName = original.threadName;
        this.hostName = original.hostName;
        this.processName = original.processName;
        this.processId = original.processId;
    }

    public static ExtLogRecord wrap(LogRecord rec) {
        if (rec == null) {
            return null;
        }
        if (rec instanceof ExtLogRecord) {
            return (ExtLogRecord)rec;
        }
        return new WrappedExtLogRecord(rec);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.copyAll();
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = ois.readFields();
        this.ndc = (String)fields.get("ndc", null);
        this.formatStyle = (FormatStyle)((Object)fields.get("formatStyle", (Object)FormatStyle.MESSAGE_FORMAT));
        this.mdcCopy = (FastCopyHashMap)fields.get("mdcCopy", new FastCopyHashMap());
        this.sourceLineNumber = fields.get("sourceLineNumber", -1);
        this.sourceFileName = (String)fields.get("sourceFileName", null);
        this.threadName = (String)fields.get("threadName", null);
        this.hostName = (String)fields.get("hostName", null);
        this.processName = (String)fields.get("processName", null);
        this.processId = fields.get("processId", -1L);
        this.sourceModuleName = (String)fields.get("sourceModuleName", null);
        this.sourceModuleVersion = (String)fields.get("sourceModuleVersion", null);
    }

    public void disableCallerCalculation() {
        if (this.calculateCaller) {
            this.setUnknownCaller();
        }
    }

    public void copyAll() {
        this.copyMdc();
        this.calculateCaller();
    }

    public void copyMdc() {
        if (this.mdcCopy == null) {
            this.mdcCopy = MDC.fastCopyObject();
        }
    }

    public String getMdc(String key) {
        FastCopyHashMap<String, Object> mdcCopy = this.mdcCopy;
        if (mdcCopy == null) {
            return MDC.get(key);
        }
        Object value = mdcCopy.get(key);
        return value == null ? null : value.toString();
    }

    public Map<String, String> getMdcCopy() {
        if (this.mdcCopy == null) {
            this.mdcCopy = MDC.fastCopyObject();
        }
        FastCopyHashMap<String, String> newMdc = new FastCopyHashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.mdcCopy.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            newMdc.put(key, value == null ? null : value.toString());
        }
        return newMdc;
    }

    public String putMdc(String key, String value) {
        this.copyMdc();
        Object oldValue = this.mdcCopy.put(key, value);
        return oldValue == null ? null : oldValue.toString();
    }

    public String removeMdc(String key) {
        this.copyMdc();
        Object oldValue = this.mdcCopy.remove(key);
        return oldValue == null ? null : oldValue.toString();
    }

    public void setMdc(Map<?, ?> sourceMap) {
        FastCopyHashMap newMdc = new FastCopyHashMap();
        for (Map.Entry<?, ?> entry : sourceMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            newMdc.put(key.toString(), value);
        }
        this.mdcCopy = newMdc;
    }

    public String getNdc() {
        return this.ndc;
    }

    public void setNdc(String value) {
        this.ndc = value;
    }

    public String getLoggerClassName() {
        return this.loggerClassName;
    }

    public FormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    private void calculateCaller() {
        if (!this.calculateCaller) {
            return;
        }
        this.calculateCaller = false;
        JDKSpecific.calculateCaller(this);
    }

    void setUnknownCaller() {
        this.setSourceClassName(null);
        this.setSourceMethodName(null);
        this.setSourceLineNumber(-1);
        this.setSourceFileName(null);
        this.setSourceModuleName(null);
        this.setSourceModuleVersion(null);
    }

    public int getSourceLineNumber() {
        this.calculateCaller();
        return this.sourceLineNumber;
    }

    public void setSourceLineNumber(int sourceLineNumber) {
        this.calculateCaller = false;
        this.sourceLineNumber = sourceLineNumber;
    }

    public String getSourceFileName() {
        this.calculateCaller();
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.calculateCaller = false;
        this.sourceFileName = sourceFileName;
    }

    @Override
    public String getSourceClassName() {
        this.calculateCaller();
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.calculateCaller = false;
        super.setSourceClassName(sourceClassName);
    }

    @Override
    public String getSourceMethodName() {
        this.calculateCaller();
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.calculateCaller = false;
        super.setSourceMethodName(sourceMethodName);
    }

    public String getSourceModuleName() {
        this.calculateCaller();
        return this.sourceModuleName;
    }

    public void setSourceModuleName(String sourceModuleName) {
        this.calculateCaller = false;
        this.sourceModuleName = sourceModuleName;
    }

    public String getSourceModuleVersion() {
        this.calculateCaller();
        return this.sourceModuleVersion;
    }

    public void setSourceModuleVersion(String sourceModuleVersion) {
        this.calculateCaller = false;
        this.sourceModuleVersion = sourceModuleVersion;
    }

    @Deprecated
    public String getFormattedMessage() {
        Object[] parameters;
        ResourceBundle bundle2 = this.getResourceBundle();
        String msg = this.getMessage();
        if (msg == null) {
            return null;
        }
        if (bundle2 != null) {
            try {
                msg = bundle2.getString(msg);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if ((parameters = this.getParameters()) == null || parameters.length == 0) {
            return msg;
        }
        switch (this.formatStyle) {
            case PRINTF: {
                return String.format(msg, parameters);
            }
            case MESSAGE_FORMAT: {
                return msg.indexOf(123) >= 0 ? MessageFormat.format(msg, parameters) : msg;
            }
        }
        return msg;
    }

    public String getResourceKey() {
        String msg = this.getMessage();
        if (msg == null) {
            return null;
        }
        if (this.getResourceBundleName() == null && this.getResourceBundle() == null) {
            return null;
        }
        return msg;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    @Override
    public void setMessage(String message) {
        this.setMessage(message, FormatStyle.MESSAGE_FORMAT);
    }

    public void setMessage(String message, FormatStyle formatStyle) {
        this.formatStyle = formatStyle == null ? FormatStyle.MESSAGE_FORMAT : formatStyle;
        super.setMessage(message);
    }

    @Override
    public void setParameters(Object[] parameters) {
        super.setParameters(parameters);
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle2) {
        super.setResourceBundle(bundle2);
    }

    @Override
    public void setResourceBundleName(String name) {
        super.setResourceBundleName(name);
    }

    public static enum FormatStyle {
        MESSAGE_FORMAT,
        PRINTF,
        NO_FORMAT;

    }
}

