/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.ManifestInfo;
import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class RunnerClassLoader
extends ClassLoader {
    private final Map<String, ClassLoadingResource[]> resourceDirectoryMap;
    private final Set<String> parentFirstPackages;
    private final ConcurrentMap<ClassLoadingResource, ProtectionDomain> protectionDomains = new ConcurrentHashMap<ClassLoadingResource, ProtectionDomain>();

    RunnerClassLoader(ClassLoader parent, Map<String, ClassLoadingResource[]> resourceDirectoryMap, Set<String> parentFirstPackages) {
        super(parent);
        this.resourceDirectoryMap = resourceDirectoryMap;
        this.parentFirstPackages = parentFirstPackages;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("java.")) {
            return this.getParent().loadClass(name);
        }
        String packageName = this.getPackageNameFromClassName(name);
        if (this.parentFirstPackages.contains(packageName)) {
            return this.getParent().loadClass(name);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            ClassLoadingResource[] resources;
            Class<?> loaded = this.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            if (packageName == null) {
                resources = this.resourceDirectoryMap.get("");
            } else {
                String dirName = packageName.replace(".", "/");
                resources = this.resourceDirectoryMap.get(dirName);
            }
            if (resources != null) {
                String classResource = name.replace(".", "/") + ".class";
                for (ClassLoadingResource resource : resources) {
                    byte[] data = resource.getResourceData(classResource);
                    if (data == null) continue;
                    this.definePackage(packageName, resources);
                    return this.defineClass(name, data, 0, data.length, this.protectionDomains.computeIfAbsent(resource, new Function<ClassLoadingResource, ProtectionDomain>(){

                        @Override
                        public ProtectionDomain apply(ClassLoadingResource ce) {
                            return ce.getProtectionDomain(RunnerClassLoader.this);
                        }
                    }));
                }
            }
        }
        return this.getParent().loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        ClassLoadingResource[] resources = this.getClassLoadingResources(name = this.sanitizeName(name));
        if (resources == null) {
            return null;
        }
        for (ClassLoadingResource resource : resources) {
            URL data = resource.getResourceURL(name);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    private String sanitizeName(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private ClassLoadingResource[] getClassLoadingResources(String name) {
        String dirName = this.getDirNameFromResourceName(name);
        ClassLoadingResource[] resources = dirName == null ? this.resourceDirectoryMap.get("") : this.resourceDirectoryMap.get(dirName);
        if (resources == null) {
            resources = this.resourceDirectoryMap.get(name);
        }
        return resources;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ClassLoadingResource[] resources = this.getClassLoadingResources(name = this.sanitizeName(name));
        if (resources == null) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (ClassLoadingResource resource : resources) {
            URL data = resource.getResourceURL(name);
            if (data == null) continue;
            urls.add(data);
        }
        return Collections.enumeration(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void definePackage(String pkgName, ClassLoadingResource[] resources) {
        if (pkgName != null && this.getPackage(pkgName) == null) {
            Object object = this.getClassLoadingLock(pkgName);
            synchronized (object) {
                if (this.getPackage(pkgName) == null) {
                    for (ClassLoadingResource classPathElement : resources) {
                        ManifestInfo mf = classPathElement.getManifestInfo();
                        if (mf == null) continue;
                        this.definePackage(pkgName, mf.getSpecTitle(), mf.getSpecVersion(), mf.getSpecVendor(), mf.getImplTitle(), mf.getImplVersion(), mf.getImplVendor(), null);
                        return;
                    }
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
        }
    }

    private String getPackageNameFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return className.substring(0, index);
    }

    private String getDirNameFromResourceName(String resourceName) {
        int index = resourceName.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return resourceName.substring(0, index);
    }

    @Override
    protected Class<?> findClass(String moduleName, String name) {
        try {
            return this.loadClass(name, false);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void close() {
        for (Map.Entry<String, ClassLoadingResource[]> entry : this.resourceDirectoryMap.entrySet()) {
            for (ClassLoadingResource i : entry.getValue()) {
                i.close();
            }
        }
    }

    static {
        RunnerClassLoader.registerAsParallelCapable();
    }
}

