/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOnItemOrFailureConsume;
import io.smallrye.mutiny.operators.UniOnItemOrFailureFlatMap;
import io.smallrye.mutiny.operators.UniOnItemOrFailureMap;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.mutiny.tuples.Functions;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class UniOnItemOrFailure<T> {
    private final Uni<T> upstream;

    public UniOnItemOrFailure(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Uni<T> invoke(BiConsumer<? super T, Throwable> callback) {
        return Infrastructure.onUniCreation(new UniOnItemOrFailureConsume<T>(this.upstream, ParameterValidation.nonNull(callback, "callback")));
    }

    public Uni<T> invokeUni(BiFunction<? super T, Throwable, ? extends Uni<?>> callback) {
        ParameterValidation.nonNull(callback, "callback");
        return this.transformToUni((? super T res, Throwable fail) -> {
            Uni uni = (Uni)callback.apply((Object)res, (Throwable)fail);
            if (uni == null) {
                throw new NullPointerException("The callback produced a `null` uni");
            }
            return uni.onItemOrFailure().transformToUni((? super T ignored, Throwable subFailure) -> {
                if (fail != null && subFailure != null) {
                    return Uni.createFrom().failure(new CompositeException((Throwable)fail, (Throwable)subFailure));
                }
                if (fail != null) {
                    return Uni.createFrom().failure((Throwable)fail);
                }
                if (subFailure != null) {
                    return Uni.createFrom().failure((Throwable)subFailure);
                }
                return Uni.createFrom().item(res);
            });
        });
    }

    @Deprecated
    public <R> Uni<R> apply(BiFunction<? super T, Throwable, ? extends R> mapper) {
        return this.transform(mapper);
    }

    public <R> Uni<R> transform(BiFunction<? super T, Throwable, ? extends R> mapper) {
        return Infrastructure.onUniCreation(new UniOnItemOrFailureMap<T, R>(this.upstream, mapper));
    }

    public <R> Uni<R> transformToUni(BiFunction<? super T, Throwable, ? extends Uni<? extends R>> mapper) {
        return Infrastructure.onUniCreation(new UniOnItemOrFailureFlatMap(this.upstream, mapper));
    }

    @Deprecated
    public <R> Uni<R> produceUni(BiFunction<? super T, Throwable, ? extends Uni<? extends R>> mapper) {
        return this.transformToUni(mapper);
    }

    public <R> Uni<R> transformToUni(Functions.TriConsumer<? super T, Throwable, UniEmitter<? super R>> consumer) {
        ParameterValidation.nonNull(consumer, "consumer");
        return this.transformToUni((? super T item, Throwable failure) -> Uni.createFrom().emitter(emitter -> {
            try {
                consumer.accept((Object)item, (Throwable)failure, (UniEmitter)emitter);
            }
            catch (Throwable e) {
                if (failure != null) {
                    emitter.fail(new CompositeException((Throwable)failure, e));
                }
                emitter.fail(e);
            }
        }));
    }

    @Deprecated
    public <R> Uni<R> produceUni(Functions.TriConsumer<? super T, Throwable, UniEmitter<? super R>> consumer) {
        return this.transformToUni(consumer);
    }
}

