/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.impl.LazyValue;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ComputingCache<K, V> {
    private final ConcurrentMap<K, LazyValue<V>> map = new ConcurrentHashMap<K, LazyValue<V>>();
    private final Function<K, LazyValue<V>> function;

    public ComputingCache(Function<K, V> computingFunction) {
        this.function = new CacheFunction(computingFunction);
    }

    public V getValue(K key) {
        LazyValue<V> previous;
        LazyValue<V> value = (LazyValue<V>)this.map.get(key);
        if (value == null && (previous = this.map.putIfAbsent(key, value = this.function.apply(key))) != null) {
            value = previous;
        }
        return (V)value.get();
    }

    public V getValueIfPresent(K key) {
        LazyValue value = (LazyValue)this.map.get(key);
        return value != null ? (V)value.getIfPresent() : null;
    }

    public V remove(K key) {
        LazyValue previous = (LazyValue)this.map.remove(key);
        return previous != null ? (V)previous.get() : null;
    }

    public void clear() {
        this.map.clear();
    }

    public void forEachValue(Consumer<? super V> action) {
        Objects.requireNonNull(action);
        for (LazyValue value : this.map.values()) {
            action.accept(value.get());
        }
    }

    public void forEachExistingValue(Consumer<? super V> action) {
        Objects.requireNonNull(action);
        for (LazyValue value : this.map.values()) {
            if (!value.isSet()) continue;
            action.accept(value.get());
        }
    }

    public Set<V> getPresentValues() {
        return this.map.values().stream().map(LazyValue::getIfPresent).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void forEachEntry(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (Map.Entry entry : this.map.entrySet()) {
            action.accept(entry.getKey(), ((LazyValue)entry.getValue()).get());
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    class CacheFunction
    implements Function<K, LazyValue<V>> {
        private final Function<K, V> computingFunction;

        public CacheFunction(Function<K, V> computingFunction) {
            this.computingFunction = computingFunction;
        }

        @Override
        public LazyValue<V> apply(K key) {
            return new LazyValue<Object>(() -> this.computingFunction.apply(key));
        }
    }
}

