/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

public class IncludeSectionHelper
implements SectionHelper {
    private static final String TEMPLATE = "template";
    private final Supplier<Template> templateSupplier;
    private final Map<String, SectionBlock> extendingBlocks;

    public IncludeSectionHelper(Supplier<Template> templateSupplier, Map<String, SectionBlock> extendingBlocks) {
        this.templateSupplier = templateSupplier;
        this.extendingBlocks = extendingBlocks;
    }

    @Override
    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
        return ((TemplateImpl)this.templateSupplier.get()).root.resolve(context.resolutionContext().createChild(this.extendingBlocks));
    }

    public static class Factory
    implements SectionHelperFactory<IncludeSectionHelper> {
        @Override
        public List<String> getDefaultAliases() {
            return ImmutableList.of("include");
        }

        @Override
        public SectionHelperFactory.ParametersInfo getParameters() {
            return SectionHelperFactory.ParametersInfo.builder().addParameter(IncludeSectionHelper.TEMPLATE).build();
        }

        @Override
        public boolean treatUnknownSectionsAsBlocks() {
            return true;
        }

        @Override
        public IncludeSectionHelper initialize(final SectionHelperFactory.SectionInitContext context) {
            HashMap<String, SectionBlock> extendingBlocks = new HashMap<String, SectionBlock>();
            for (SectionBlock block : context.getBlocks().subList(1, context.getBlocks().size())) {
                extendingBlocks.put(block.label, block);
            }
            return new IncludeSectionHelper(new Supplier<Template>(){

                @Override
                public Template get() {
                    String name = context.getParameter(IncludeSectionHelper.TEMPLATE);
                    Template template = context.getEngine().getTemplate(name);
                    if (template == null) {
                        throw new IllegalStateException("Template not found: " + name);
                    }
                    return template;
                }
            }, extendingBlocks);
        }
    }
}

