/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigMessages;
import io.smallrye.config.PropertiesConfigSource;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class PropertiesConfigSourceProvider
implements ConfigSourceProvider {
    private List<ConfigSource> configSources = new ArrayList<ConfigSource>();

    public PropertiesConfigSourceProvider(String propertyFileName, boolean optional, ClassLoader classLoader) {
        try {
            Enumeration<URL> propertyFileUrls = classLoader.getResources(propertyFileName);
            if (!optional && !propertyFileUrls.hasMoreElements()) {
                throw ConfigMessages.msg.fileNotFound(propertyFileName);
            }
            while (propertyFileUrls.hasMoreElements()) {
                URL propertyFileUrl = propertyFileUrls.nextElement();
                this.configSources.add(new PropertiesConfigSource(propertyFileUrl));
            }
        }
        catch (IOException ioe) {
            throw ConfigMessages.msg.failedToLoadConfig(ioe);
        }
    }

    public List<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return this.configSources;
    }
}

