/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.groups.UniAndGroup;
import io.smallrye.mutiny.groups.UniAwait;
import io.smallrye.mutiny.groups.UniCombine;
import io.smallrye.mutiny.groups.UniConvert;
import io.smallrye.mutiny.groups.UniCreate;
import io.smallrye.mutiny.groups.UniIfNoItem;
import io.smallrye.mutiny.groups.UniOnEvent;
import io.smallrye.mutiny.groups.UniOnFailure;
import io.smallrye.mutiny.groups.UniOnItem;
import io.smallrye.mutiny.groups.UniOnItemOrFailure;
import io.smallrye.mutiny.groups.UniOnSubscribe;
import io.smallrye.mutiny.groups.UniOnTerminate;
import io.smallrye.mutiny.groups.UniOr;
import io.smallrye.mutiny.groups.UniRepeat;
import io.smallrye.mutiny.groups.UniSubscribe;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.tuples.Tuple2;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Uni<T> {
    public static UniCreate createFrom() {
        return UniCreate.INSTANCE;
    }

    @Deprecated
    default public <O> O then(Function<Uni<T>, O> stage) {
        return this.stage(stage);
    }

    default public <O> O stage(Function<Uni<T>, O> stage) {
        return ParameterValidation.nonNull(stage, "stage").apply(this);
    }

    public static UniCombine combine() {
        return UniCombine.INSTANCE;
    }

    public UniSubscribe<T> subscribe();

    default public CompletableFuture<T> subscribeAsCompletionStage() {
        return this.subscribe().asCompletionStage();
    }

    public UniAwait<T> await();

    public UniOnItem<T> onItem();

    public UniOnSubscribe<T> onSubscribe();

    public UniOnItemOrFailure<T> onItemOrFailure();

    @Deprecated
    public UniAndGroup<T> and();

    @Deprecated
    public <T2> Uni<Tuple2<T, T2>> and(Uni<T2> var1);

    @Deprecated
    public UniOr<T> or();

    public UniOnFailure<T> onFailure();

    public UniOnFailure<T> onFailure(Predicate<? super Throwable> var1);

    public UniOnFailure<T> onFailure(Class<? extends Throwable> var1);

    public UniIfNoItem<T> ifNoItem();

    public Uni<T> emitOn(Executor var1);

    @Deprecated
    default public Uni<T> subscribeOn(Executor executor) {
        return this.runSubscriptionOn(executor);
    }

    public Uni<T> runSubscriptionOn(Executor var1);

    public Uni<T> cache();

    default public <O> Uni<O> map(Function<? super T, ? extends O> mapper) {
        return this.onItem().transform(ParameterValidation.nonNull(mapper, "mapper"));
    }

    default public Uni<T> invoke(Consumer<? super T> callback) {
        return this.onItem().invoke(ParameterValidation.nonNull(callback, "callback"));
    }

    default public Uni<T> invokeUni(Function<? super T, ? extends Uni<?>> action) {
        return this.onItem().invokeUni(ParameterValidation.nonNull(action, "action"));
    }

    default public <O> Uni<O> flatMap(Function<? super T, Uni<? extends O>> mapper) {
        return this.onItem().transformToUni(ParameterValidation.nonNull(mapper, "mapper"));
    }

    default public <O> Uni<O> chain(Function<? super T, Uni<? extends O>> mapper) {
        return this.onItem().transformToUni(ParameterValidation.nonNull(mapper, "mapper"));
    }

    default public <O> Uni<O> then(Supplier<Uni<? extends O>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.onItem().transformToUni(ignored -> (Uni)actual.get());
    }

    default public Uni<T> eventually(Runnable action) {
        return this.onItemOrFailure().invoke((? super T item, Throwable err) -> ParameterValidation.nonNull(action, "action").run());
    }

    default public <O> Uni<T> eventually(Supplier<Uni<? extends O>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.onItemOrFailure().invokeUni((? super T item, Throwable err) -> (Uni)actual.get());
    }

    public UniConvert<T> convert();

    public Multi<T> toMulti();

    public UniOnEvent<T> on();

    public UniRepeat<T> repeat();

    public UniOnTerminate<T> onTermination();
}

