/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.EvalContext;
import io.quarkus.qute.FieldWrapper;
import io.quarkus.qute.MemberKey;
import io.quarkus.qute.MemberWrapper;
import io.quarkus.qute.MethodWrapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.ValueResolver;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReflectionValueResolver
implements ValueResolver {
    private final ConcurrentMap<MemberKey, Optional<MemberWrapper>> memberCache = new ConcurrentHashMap<MemberKey, Optional<MemberWrapper>>();
    private static final MemberWrapper ARRAY_GET_LENGTH = Array::getLength;
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String HAS_PREFIX = "has";

    @Override
    public int getPriority() {
        return -1;
    }

    @Override
    public boolean appliesTo(EvalContext context) {
        Object base = context.getBase();
        if (base == null) {
            return false;
        }
        return this.memberCache.computeIfAbsent(MemberKey.newInstance(base, context.getName()), ReflectionValueResolver::findWrapper).isPresent();
    }

    @Override
    public CompletionStage<Object> resolve(EvalContext context) {
        Object base = context.getBase();
        MemberKey key = MemberKey.newInstance(base, context.getName());
        MemberWrapper wrapper = this.memberCache.computeIfAbsent(key, ReflectionValueResolver::findWrapper).orElse(null);
        if (wrapper == null) {
            return Results.NOT_FOUND;
        }
        try {
            return CompletableFuture.completedFuture(wrapper.getValue(base));
        }
        catch (Exception e) {
            throw new IllegalStateException("Reflection invocation error", e);
        }
    }

    public void clearMemberCache() {
        this.memberCache.clear();
    }

    private static Optional<MemberWrapper> findWrapper(MemberKey key) {
        if (key.getClazz().isArray()) {
            if (key.getName().equals("length")) {
                return Optional.of(ARRAY_GET_LENGTH);
            }
            return Optional.empty();
        }
        Method foundMethod = ReflectionValueResolver.findMethod(key.getClazz(), key.getName());
        if (foundMethod != null) {
            if (!foundMethod.isAccessible()) {
                foundMethod.setAccessible(true);
            }
            return Optional.of(new MethodWrapper(foundMethod));
        }
        Field foundField = ReflectionValueResolver.findField(key.getClazz(), key.getName());
        if (foundField != null) {
            if (!foundField.isAccessible()) {
                foundField.setAccessible(true);
            }
            return Optional.of(new FieldWrapper(foundField));
        }
        return Optional.empty();
    }

    private static Method findMethod(Class<?> clazz, String name) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(name);
        Method foundMatch = null;
        Method foundGetterMatch = null;
        Method foundBooleanMatch = null;
        for (Method method : clazz.getMethods()) {
            if (!ReflectionValueResolver.isMethodValid(method) || method.isBridge()) continue;
            if (name.equals(method.getName())) {
                foundMatch = method;
                continue;
            }
            if (ReflectionValueResolver.matchesPrefix(name, method.getName(), GET_PREFIX)) {
                foundGetterMatch = method;
                continue;
            }
            if (!ReflectionValueResolver.isBoolean(method.getReturnType()) || !ReflectionValueResolver.matchesPrefix(name, method.getName(), IS_PREFIX) && !ReflectionValueResolver.matchesPrefix(name, method.getName(), HAS_PREFIX)) continue;
            foundBooleanMatch = method;
        }
        if (foundMatch == null) {
            foundMatch = foundGetterMatch != null ? foundGetterMatch : foundBooleanMatch;
        }
        return foundMatch;
    }

    private static Field findField(Class<?> clazz, String name) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(name);
        Field found = null;
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(name)) continue;
            found = field;
        }
        return found;
    }

    private static boolean isMethodValid(Method method) {
        return method != null && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE) && !Object.class.equals(method.getDeclaringClass());
    }

    private static boolean matchesPrefix(String name, String methodName, String prefix) {
        return methodName.startsWith(prefix) && ReflectionValueResolver.decapitalize(methodName.substring(prefix.length(), methodName.length())).equals(name);
    }

    private static boolean isBoolean(Class<?> type) {
        return type.equals(Boolean.class) || type.equals(Boolean.TYPE);
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

