/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime;

import io.quarkus.qute.Engine;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateInstanceBase;
import io.quarkus.qute.Variant;
import io.quarkus.qute.api.ResourcePath;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.QuteRecorder;
import io.smallrye.mutiny.Multi;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class TemplateProducer {
    private static final Logger LOGGER = Logger.getLogger(TemplateProducer.class);
    private final Engine engine;
    private final Map<String, TemplateVariants> templateVariants;

    TemplateProducer(Engine engine, QuteRecorder.QuteContext context, ContentTypes contentTypes) {
        this.engine = engine;
        HashMap<String, TemplateVariants> templateVariants = new HashMap<String, TemplateVariants>();
        for (Map.Entry<String, List<String>> entry : context.getVariants().entrySet()) {
            TemplateVariants var = new TemplateVariants(TemplateProducer.initVariants(entry.getKey(), entry.getValue(), contentTypes), entry.getKey());
            templateVariants.put(entry.getKey(), var);
        }
        this.templateVariants = Collections.unmodifiableMap(templateVariants);
        LOGGER.debugf("Initializing Qute variant templates: %s", (Object)templateVariants);
    }

    @Produces
    Template getDefaultTemplate(InjectionPoint injectionPoint) {
        String name = null;
        if (injectionPoint.getMember() instanceof Field) {
            name = injectionPoint.getMember().getName();
        } else {
            AnnotatedParameter parameter = (AnnotatedParameter)injectionPoint.getAnnotated();
            if (parameter.getJavaParameter().isNamePresent()) {
                name = parameter.getJavaParameter().getName();
            } else {
                name = injectionPoint.getMember().getName();
                LOGGER.warnf("Parameter name not present - using the method name as the template name instead %s", (Object)name);
            }
        }
        return new InjectableTemplate(name, this.templateVariants, this.engine);
    }

    @Produces
    @ResourcePath(value="ignored")
    Template getTemplate(InjectionPoint injectionPoint) {
        ResourcePath path = null;
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ResourcePath.class)) continue;
            path = (ResourcePath)qualifier;
            break;
        }
        if (path == null || path.value().isEmpty()) {
            throw new IllegalStateException("No template reource path specified");
        }
        return new InjectableTemplate(path.value(), this.templateVariants, this.engine);
    }

    public Template getInjectableTemplate(String path) {
        return new InjectableTemplate(path, this.templateVariants, this.engine);
    }

    private static Map<Variant, String> initVariants(String base, List<String> availableVariants, ContentTypes contentTypes) {
        HashMap<Variant, String> map = new HashMap<Variant, String>();
        for (String path : availableVariants) {
            if (base.equals(path)) continue;
            map.put(new Variant(null, contentTypes.getContentType(path), null), path);
        }
        return map;
    }

    static class TemplateVariants {
        public final Map<Variant, String> variantToTemplate;
        public final String defaultTemplate;

        public TemplateVariants(Map<Variant, String> variants, String defaultTemplate) {
            this.variantToTemplate = variants;
            this.defaultTemplate = defaultTemplate;
        }

        public String toString() {
            return "TemplateVariants{default=" + this.defaultTemplate + ", variants=" + this.variantToTemplate + "}";
        }
    }

    static class InjectableTemplateInstanceImpl
    extends TemplateInstanceBase {
        private final String path;
        private final TemplateVariants variants;
        private final Engine engine;

        public InjectableTemplateInstanceImpl(String path, TemplateVariants variants, Engine engine) {
            this.path = path;
            this.variants = variants;
            this.engine = engine;
            if (variants != null) {
                this.setAttribute("variants", new ArrayList<Variant>(variants.variantToTemplate.keySet()));
            }
        }

        @Override
        public String render() {
            return this.templateInstance().render();
        }

        @Override
        public CompletionStage<String> renderAsync() {
            return this.templateInstance().renderAsync();
        }

        @Override
        public Multi<String> createMulti() {
            return this.templateInstance().createMulti();
        }

        @Override
        public CompletionStage<Void> consume(Consumer<String> consumer) {
            return this.templateInstance().consume(consumer);
        }

        private TemplateInstance templateInstance() {
            TemplateInstance instance = this.template().instance();
            instance.data(this.data());
            if (!this.attributes.isEmpty()) {
                for (Map.Entry entry : this.attributes.entrySet()) {
                    instance.setAttribute((String)entry.getKey(), entry.getValue());
                }
            }
            return instance;
        }

        private Template template() {
            String id;
            Variant selected = (Variant)this.getAttribute("selectedVariant");
            if (selected != null) {
                id = this.variants.variantToTemplate.get(selected);
                if (id == null) {
                    id = this.variants.defaultTemplate;
                }
            } else {
                id = this.path;
            }
            return this.engine.getTemplate(id);
        }
    }

    static class InjectableTemplate
    implements Template {
        private final String path;
        private final TemplateVariants variants;
        private final Engine engine;

        public InjectableTemplate(String path, Map<String, TemplateVariants> templateVariants, Engine engine) {
            this.path = path;
            this.variants = templateVariants.get(path);
            this.engine = engine;
        }

        @Override
        public TemplateInstance instance() {
            return new InjectableTemplateInstanceImpl(this.path, this.variants, this.engine);
        }

        @Override
        public Set<Expression> getExpressions() {
            throw new UnsupportedOperationException("Injected templates do not support getExpressions()");
        }

        @Override
        public String getGeneratedId() {
            throw new UnsupportedOperationException("Injected templates do not support getGeneratedId()");
        }

        @Override
        public Optional<Variant> getVariant() {
            throw new UnsupportedOperationException("Injected templates do not support getVariant()");
        }
    }
}

