/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.function;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionBiConsumer;
import io.smallrye.common.function.ExceptionBiFunction;
import io.smallrye.common.function.ExceptionBiPredicate;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionPredicate;
import io.smallrye.common.function.ExceptionSupplier;

@FunctionalInterface
public interface ExceptionFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    default public <R2> ExceptionFunction<T, R2, E> andThen(ExceptionFunction<? super R, ? extends R2, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return t -> after.apply((R)this.apply(t));
    }

    default public <R2> ExceptionFunction<T, R2, E> andThen(ExceptionBiFunction<? super T, ? super R, ? extends R2, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return t -> after.apply((T)t, (R)this.apply(t));
    }

    default public <T2> ExceptionFunction<T2, R, E> compose(ExceptionFunction<? super T2, ? extends T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return t -> this.apply(before.apply((Object)t));
    }

    default public ExceptionConsumer<T, E> andThen(ExceptionConsumer<? super R, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return t -> after.accept((R)this.apply(t));
    }

    default public ExceptionConsumer<T, E> andThen(ExceptionBiConsumer<? super T, ? super R, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return t -> after.accept((T)t, (R)this.apply(t));
    }

    default public ExceptionPredicate<T, E> andThen(ExceptionPredicate<? super R, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return t -> after.test((R)this.apply(t));
    }

    default public ExceptionPredicate<T, E> andThen(ExceptionBiPredicate<? super T, ? super R, ? extends E> after) {
        Assert.checkNotNullParam("after", after);
        return t -> after.test((T)t, (R)this.apply(t));
    }

    default public ExceptionSupplier<R, E> compose(ExceptionSupplier<? extends T, ? extends E> before) {
        Assert.checkNotNullParam("before", before);
        return () -> this.apply(before.get());
    }
}

