/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniFailOnTimeout;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public class UniOnTimeout<T> {
    private final Uni<T> failure;
    private final Duration timeout;
    private final ScheduledExecutorService executor;

    public UniOnTimeout(Uni<T> upstream, Duration timeout, ScheduledExecutorService executor) {
        this.failure = ParameterValidation.nonNull(upstream, "upstream");
        this.timeout = timeout;
        this.executor = executor;
    }

    public UniOnTimeout<T> after(Duration timeout) {
        return new UniOnTimeout<T>(this.failure, ParameterValidation.validate(timeout, "timeout"), this.executor);
    }

    public UniOnTimeout<T> on(ScheduledExecutorService executor) {
        return new UniOnTimeout<T>(this.failure, this.timeout, ParameterValidation.nonNull(executor, "executor"));
    }

    public Uni<T> fail() {
        return Infrastructure.onUniCreation(this.failWith(TimeoutException::new));
    }

    public Uni<T> failWith(Throwable failure) {
        return this.failWith(() -> failure);
    }

    public Uni<T> failWith(Supplier<? extends Throwable> supplier) {
        ParameterValidation.validate(this.timeout, "timeout");
        ParameterValidation.nonNull(supplier, "supplier");
        return Infrastructure.onUniCreation(new UniFailOnTimeout<T>(this.failure, this.timeout, supplier, this.executor));
    }

    public Uni<T> recoverWithItem(T fallback) {
        return this.fail().onFailure(TimeoutException.class).recoverWithItem(fallback);
    }

    public Uni<T> recoverWithItem(Supplier<T> supplier) {
        return this.fail().onFailure(TimeoutException.class).recoverWithItem(supplier);
    }

    public Uni<T> recoverWithUni(Supplier<? extends Uni<? extends T>> supplier) {
        return this.fail().onFailure(TimeoutException.class).recoverWithUni(supplier);
    }

    public Uni<T> recoverWithUni(Uni<? extends T> fallback) {
        return this.fail().onFailure(TimeoutException.class).recoverWithUni(fallback);
    }
}

