/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.MultiRepeatUntilOp;
import io.smallrye.mutiny.operators.multi.MultiRepeatWhilstOp;
import java.util.function.Predicate;

public class UniRepeat<T> {
    private final Uni<T> upstream;

    public UniRepeat(Uni<T> upstream) {
        this.upstream = upstream;
    }

    public Multi<T> indefinitely() {
        return this.atMost(Long.MAX_VALUE);
    }

    public Multi<T> atMost(long times) {
        long actual = ParameterValidation.positive(times, "times");
        return new MultiRepeatUntilOp<T>(this.upstream.toMulti(), actual);
    }

    public Multi<T> until(Predicate<T> predicate) {
        return new MultiRepeatUntilOp<T>(this.upstream.toMulti(), ParameterValidation.nonNull(predicate, "predicate"));
    }

    public Multi<T> whilst(Predicate<T> predicate) {
        return new MultiRepeatWhilstOp<T>(this.upstream.toMulti(), ParameterValidation.nonNull(predicate, "predicate"));
    }
}

