/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.aot.graalvm.processor;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import picocli.CommandLine;
import picocli.codegen.aot.graalvm.processor.IGenerator;
import picocli.codegen.aot.graalvm.processor.ProcessorUtil;

abstract class AbstractGenerator
implements IGenerator {
    public static final String OPTION_VERBOSE = "verbose";
    protected final ProcessingEnvironment processingEnv;
    private final String fileName;
    private final String disableKey;

    public AbstractGenerator(ProcessingEnvironment processingEnv, String fileName, String disableKey) {
        this.processingEnv = processingEnv;
        this.fileName = fileName;
        this.disableKey = disableKey;
    }

    protected abstract String generateConfig(CommandLine.Model.CommandSpec[] var1) throws Exception;

    @Override
    public void generate(Map<Element, CommandLine.Model.CommandSpec> allCommands) {
        if (!this.enabled()) {
            this.logInfo("is not enabled");
            return;
        }
        try {
            String path = this.createRelativePath(this.fileName());
            this.logInfo("writing to: " + StandardLocation.CLASS_OUTPUT + "/" + path);
            String text = this.generateConfig(allCommands);
            ProcessorUtil.generate(StandardLocation.CLASS_OUTPUT, path, text, this.processingEnv, allCommands.keySet().toArray(new Element[0]));
        }
        catch (Exception e) {
            this.fatalError(ProcessorUtil.stacktrace(e));
        }
    }

    protected boolean enabled() {
        Map<String, String> options = this.processingEnv.getOptions();
        return !options.containsKey(this.disableKey);
    }

    protected String fileName() {
        return this.fileName;
    }

    protected String createRelativePath(String fileName) {
        Map<String, String> options = this.processingEnv.getOptions();
        String id = options.get("project");
        String relativeName = "META-INF/native-image/picocli-generated/";
        if (id != null) {
            relativeName = relativeName + id.replace('\\', '/') + "/";
        }
        return relativeName + fileName;
    }

    protected String generateConfig(Map<Element, CommandLine.Model.CommandSpec> allCommands) throws Exception {
        return this.generateConfig(allCommands.values().toArray(new CommandLine.Model.CommandSpec[0]));
    }

    protected void logInfo(String msg) {
        if (this.processingEnv.getOptions().containsKey(OPTION_VERBOSE)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, this.getClass().getSimpleName() + " " + msg);
        }
    }

    protected void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }
}

