/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.compatibility.parsing;

import java.util.HashMap;
import java.util.Map;

public enum ElementJdbc {
    UNKNOWN(null),
    STRING_KEYED_JDBC_STORE("stringKeyedJdbcStore"),
    BINARY_KEYED_JDBC_STORE("binaryKeyedJdbcStore"),
    MIXED_KEYED_JDBC_STORE("mixedKeyedJdbcStore"),
    CONNECTION_POOL("connectionPool"),
    DATA_SOURCE("dataSource"),
    SIMPLE_CONNECTION("simpleConnection"),
    BINARY_KEYED_TABLE("binaryKeyedTable"),
    STRING_KEYED_TABLE("stringKeyedTable"),
    DATA_COLUMN("dataColumn"),
    ID_COLUMN("idColumn"),
    TIMESTAMP_COLUMN("timestampColumn");

    private final String name;
    private static final Map<String, ElementJdbc> MAP;

    private ElementJdbc(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static ElementJdbc forName(String localName) {
        ElementJdbc elementJdbc = MAP.get(localName);
        return elementJdbc == null ? UNKNOWN : elementJdbc;
    }

    static {
        HashMap<String, ElementJdbc> map = new HashMap<String, ElementJdbc>(8);
        for (ElementJdbc elementJdbc : ElementJdbc.values()) {
            String name = elementJdbc.getLocalName();
            if (name == null) continue;
            map.put(name, elementJdbc);
        }
        MAP = map;
    }
}

