/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.CacheException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.util.Immutables;
import org.infinispan.util.PeekableMap;
import org.infinispan.util.concurrent.jdk8backported.BoundedConcurrentHashMapV8;
import org.infinispan.util.concurrent.jdk8backported.ConcurrentHashMapV8;

@ThreadSafe
public class DefaultDataContainer
implements DataContainer {
    protected final ConcurrentMap<Object, InternalCacheEntry> entries;
    private final ExtendedMap extendedMap;
    protected InternalEntryFactory entryFactory;
    private EvictionManager evictionManager;
    private PassivationManager passivator;
    private ActivationManager activator;
    private CacheLoaderManager clm;

    public DefaultDataContainer(int concurrencyLevel) {
        this.entries = new ConcurrentHashMapV8<Object, InternalCacheEntry>(128, 0.75f, concurrencyLevel);
        this.extendedMap = new ConcurrentExtendedMap();
    }

    protected DefaultDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy) {
        BoundedConcurrentHashMapV8.Eviction eviction;
        DefaultEvictionListener evictionListener;
        switch (policy) {
            case PIGGYBACK: 
            case DEFAULT: {
                evictionListener = new DefaultEvictionListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction thread policy " + (Object)((Object)strategy));
            }
        }
        switch (strategy) {
            case FIFO: 
            case UNORDERED: 
            case LRU: {
                eviction = BoundedConcurrentHashMapV8.Eviction.LRU;
                break;
            }
            case LIRS: {
                eviction = BoundedConcurrentHashMapV8.Eviction.LIRS;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction strategy " + (Object)((Object)strategy));
            }
        }
        this.entries = new BoundedConcurrentHashMapV8<Object, InternalCacheEntry>((long)maxEntries, eviction, evictionListener);
        this.extendedMap = new BoundedConcurrentExtendedMap();
    }

    @Inject
    public void initialize(EvictionManager evictionManager, PassivationManager passivator, InternalEntryFactory entryFactory, ActivationManager activator, CacheLoaderManager clm) {
        this.evictionManager = evictionManager;
        this.passivator = passivator;
        this.entryFactory = entryFactory;
        this.activator = activator;
        this.clm = clm;
    }

    public static DataContainer boundedDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy) {
        return new DefaultDataContainer(concurrencyLevel, maxEntries, strategy, policy);
    }

    public static DataContainer unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry peek(Object key) {
        if (this.entries instanceof PeekableMap) {
            return (InternalCacheEntry)((PeekableMap)((Object)this.entries)).peek(key);
        }
        return (InternalCacheEntry)this.entries.get(key);
    }

    @Override
    public InternalCacheEntry get(Object k) {
        InternalCacheEntry e = this.peek(k);
        if (e != null && e.canExpire()) {
            long currentTimeMillis = System.currentTimeMillis();
            if (e.isExpired(currentTimeMillis)) {
                this.entries.remove(k);
                e = null;
            } else {
                e.touch(currentTimeMillis);
            }
        }
        return e;
    }

    @Override
    public void put(Object k, Object v, EntryVersion version, long lifespan, long maxIdle) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (e != null) {
            e.setValue(v);
            InternalCacheEntry original = e;
            e.setVersion(version);
            e = this.entryFactory.update(e, lifespan, maxIdle);
            if (original == e) {
                e.reincarnate();
            }
        } else {
            e = this.entryFactory.create(k, v, version, lifespan, maxIdle);
        }
        this.extendedMap.putAndActivate(e);
    }

    @Override
    public boolean containsKey(Object k) {
        InternalCacheEntry ice = this.peek(k);
        if (ice != null && ice.canExpire() && ice.isExpired(System.currentTimeMillis())) {
            this.entries.remove(k);
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry remove(Object k) {
        InternalCacheEntry e = this.extendedMap.removeAndActivate(k);
        return e == null || e.canExpire() && e.isExpired(System.currentTimeMillis()) ? null : e;
    }

    @Override
    public void evict(Object k) {
        this.extendedMap.evict(k);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public Collection<Object> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry> entrySet() {
        return new EntrySet();
    }

    @Override
    public void purgeExpired() {
        long currentTimeMillis = System.currentTimeMillis();
        Iterator purgeCandidates = this.entries.values().iterator();
        while (purgeCandidates.hasNext()) {
            InternalCacheEntry e = (InternalCacheEntry)purgeCandidates.next();
            if (!e.isExpired(currentTimeMillis)) continue;
            purgeCandidates.remove();
        }
    }

    @Override
    public void compute(Object key, DataContainer.ComputeAction action) {
        this.extendedMap.compute(key, action);
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new EntryIterator(this.entries.values().iterator());
    }

    private class BoundedConcurrentExtendedMap
    implements ExtendedMap {
        private BoundedConcurrentExtendedMap() {
        }

        @Override
        public void evict(Object key) {
            ((BoundedConcurrentHashMapV8)DefaultDataContainer.this.entries).computeIfPresent(key, new BoundedConcurrentHashMapV8.BiFun<Object, InternalCacheEntry, InternalCacheEntry>(){

                @Override
                public InternalCacheEntry apply(Object o, InternalCacheEntry entry) {
                    DefaultDataContainer.this.passivator.passivate(entry);
                    return null;
                }
            });
        }

        @Override
        public void putAndActivate(final InternalCacheEntry newEntry) {
            ((BoundedConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(newEntry.getKey(), new BoundedConcurrentHashMapV8.BiFun<Object, InternalCacheEntry, InternalCacheEntry>(){

                @Override
                public InternalCacheEntry apply(Object key, InternalCacheEntry entry) {
                    if (entry == null) {
                        DefaultDataContainer.this.activator.activate(key);
                    }
                    return newEntry;
                }
            });
        }

        @Override
        public InternalCacheEntry removeAndActivate(Object key) {
            final AtomicReference<Object> reference = new AtomicReference<Object>(null);
            ((BoundedConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(key, new BoundedConcurrentHashMapV8.BiFun<Object, InternalCacheEntry, InternalCacheEntry>(){

                @Override
                public InternalCacheEntry apply(Object key, InternalCacheEntry entry) {
                    DefaultDataContainer.this.activator.activate(key);
                    reference.set(entry);
                    return null;
                }
            });
            return reference.get();
        }

        @Override
        public void compute(Object key, final DataContainer.ComputeAction action) {
            ((BoundedConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(key, new BoundedConcurrentHashMapV8.BiFun<Object, InternalCacheEntry, InternalCacheEntry>(){

                @Override
                public InternalCacheEntry apply(Object key, InternalCacheEntry oldEntry) {
                    InternalCacheEntry newEntry = action.compute(key, oldEntry, DefaultDataContainer.this.entryFactory);
                    if (newEntry == oldEntry) {
                        return oldEntry;
                    }
                    if (newEntry == null) {
                        return null;
                    }
                    if (oldEntry == null) {
                        DefaultDataContainer.this.activator.activate(key);
                    }
                    return newEntry;
                }
            });
        }
    }

    private class ConcurrentExtendedMap
    implements ExtendedMap {
        private ConcurrentExtendedMap() {
        }

        @Override
        public void evict(Object key) {
            ((ConcurrentHashMapV8)DefaultDataContainer.this.entries).computeIfPresent(key, new ConcurrentHashMapV8.BiFun<Object, InternalCacheEntry, InternalCacheEntry>(){

                @Override
                public InternalCacheEntry apply(Object o, InternalCacheEntry entry) {
                    DefaultDataContainer.this.passivator.passivate(entry);
                    return null;
                }
            });
        }

        @Override
        public void compute(Object key, final DataContainer.ComputeAction action) {
            ((ConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(key, new ConcurrentHashMapV8.BiFun<Object, InternalCacheEntry, InternalCacheEntry>(){

                @Override
                public InternalCacheEntry apply(Object key, InternalCacheEntry oldEntry) {
                    InternalCacheEntry newEntry = action.compute(key, oldEntry, DefaultDataContainer.this.entryFactory);
                    if (newEntry == oldEntry) {
                        return oldEntry;
                    }
                    if (newEntry == null) {
                        return null;
                    }
                    if (oldEntry == null) {
                        DefaultDataContainer.this.activator.activate(key);
                    }
                    return newEntry;
                }
            });
        }

        @Override
        public void putAndActivate(final InternalCacheEntry newEntry) {
            ((ConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(newEntry.getKey(), new ConcurrentHashMapV8.BiFun<Object, InternalCacheEntry, InternalCacheEntry>(){

                @Override
                public InternalCacheEntry apply(Object key, InternalCacheEntry entry) {
                    if (entry == null) {
                        DefaultDataContainer.this.activator.activate(key);
                    }
                    return newEntry;
                }
            });
        }

        @Override
        public InternalCacheEntry removeAndActivate(Object key) {
            final AtomicReference<Object> reference = new AtomicReference<Object>(null);
            ((ConcurrentHashMapV8)DefaultDataContainer.this.entries).compute(key, new ConcurrentHashMapV8.BiFun<Object, InternalCacheEntry, InternalCacheEntry>(){

                @Override
                public InternalCacheEntry apply(Object key, InternalCacheEntry entry) {
                    DefaultDataContainer.this.activator.activate(key);
                    reference.set(entry);
                    return null;
                }
            });
            return reference.get();
        }
    }

    private static interface ExtendedMap {
        public void evict(Object var1);

        public void putAndActivate(InternalCacheEntry var1);

        public void compute(Object var1, DataContainer.ComputeAction var2);

        public InternalCacheEntry removeAndActivate(Object var1);
    }

    private static class ValueIterator
    implements Iterator<Object> {
        Iterator<InternalCacheEntry> currentIterator;

        private ValueIterator(Iterator<InternalCacheEntry> it) {
            this.currentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            return this.currentIterator.next().getValue();
        }
    }

    private class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry> {
        private EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            InternalCacheEntry ice = (InternalCacheEntry)DefaultDataContainer.this.entries.get(e.getKey());
            if (ice == null) {
                return false;
            }
            return ice.getValue().equals(e.getValue());
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new ImmutableEntryIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }
    }

    public static class EntryIterator
    implements Iterator<InternalCacheEntry> {
        private final Iterator<InternalCacheEntry> it;

        EntryIterator(Iterator<InternalCacheEntry> it) {
            this.it = it;
        }

        @Override
        public InternalCacheEntry next() {
            return this.it.next();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImmutableEntryIterator
    extends EntryIterator {
        ImmutableEntryIterator(Iterator<InternalCacheEntry> it) {
            super(it);
        }

        @Override
        public InternalCacheEntry next() {
            return Immutables.immutableInternalCacheEntry(super.next());
        }
    }

    private final class DefaultEvictionListener
    implements BoundedConcurrentHashMapV8.EvictionListener<Object, InternalCacheEntry> {
        private DefaultEvictionListener() {
        }

        @Override
        public void onEntryEviction(Map<Object, InternalCacheEntry> evicted) {
            DefaultDataContainer.this.evictionManager.onEntryEviction(evicted);
        }

        @Override
        public void onEntryChosenForEviction(Map.Entry<Object, InternalCacheEntry> entry) {
            DefaultDataContainer.this.passivator.passivate(entry.getValue());
        }

        @Override
        public void onEntryActivated(Object key) {
            DefaultDataContainer.this.activator.activate(key);
        }

        @Override
        public void onEntryRemoved(Map.Entry<Object, InternalCacheEntry> entry) {
            try {
                CacheStore cacheStore = DefaultDataContainer.this.clm.getCacheStore();
                if (cacheStore != null) {
                    cacheStore.remove(entry.getKey());
                }
            }
            catch (CacheLoaderException e) {
                throw new CacheException(e);
            }
        }
    }
}

