/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.atomic.DeltaCompositeKey;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.TimeoutException;

public abstract class AbstractTxLockingInterceptor
extends AbstractLockingInterceptor {
    protected TransactionTable txTable;
    protected RpcManager rpcManager;
    private boolean clustered;

    @Inject
    public void setDependencies(TransactionTable txTable, RpcManager rpcManager) {
        this.txTable = txTable;
        this.rpcManager = rpcManager;
        this.clustered = rpcManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        command.setFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.CACHE_MODE_LOCAL);
        try {
            this.lockKey(ctx, command.getKey(), 0L, command.hasFlag(Flag.SKIP_LOCKING));
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object object = super.visitGetKeyValueCommand(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = super.visitCommitCommand(ctx, command);
            return object;
        }
        finally {
            if (this.releaseLockOnTxCompletion(ctx)) {
                this.lockManager.unlockAll(ctx);
            }
        }
    }

    protected final Object invokeNextAndCommitIf1Pc(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object result = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit() && this.releaseLockOnTxCompletion(ctx)) {
            this.lockManager.unlockAll(ctx);
        }
        return result;
    }

    protected final void lockAndRegisterBackupLock(TxInvocationContext ctx, Object key, long lockTimeout, boolean skipLocking) throws InterruptedException {
        Object keyToCheck;
        Object object = keyToCheck = key instanceof DeltaCompositeKey ? ((DeltaCompositeKey)key).getDeltaAwareValueKey() : key;
        if (this.cdl.localNodeIsPrimaryOwner(keyToCheck)) {
            this.lockKeyAndCheckOwnership(ctx, key, lockTimeout, skipLocking);
        } else if (this.cdl.localNodeIsOwner(keyToCheck)) {
            ctx.getCacheTransaction().addBackupLockForKey(key);
        }
    }

    protected final void lockKeyAndCheckOwnership(InvocationContext ctx, Object key, long lockTimeout, boolean skipLocking) throws InterruptedException {
        TxInvocationContext txContext = (TxInvocationContext)ctx;
        int transactionTopologyId = -1;
        boolean checkForPendingLocks = false;
        if (this.clustered) {
            boolean isFromStateTransfer;
            CacheTransaction tx = txContext.getCacheTransaction();
            boolean bl = isFromStateTransfer = txContext.isOriginLocal() && ((LocalTransaction)tx).isFromStateTransfer();
            if (!isFromStateTransfer && (transactionTopologyId = tx.getTopologyId()) != -1) {
                boolean bl2 = checkForPendingLocks = this.txTable.getMinTopologyId() < transactionTopologyId;
            }
        }
        if (checkForPendingLocks) {
            this.getLog().tracef("Checking for pending locks and then locking key %s", key);
            long expectedEndTime = this.nowMillis() + this.cacheConfiguration.locking().lockAcquisitionTimeout();
            this.waitForTransactionsToComplete(txContext, this.txTable.getLocalTransactions(), key, transactionTopologyId, expectedEndTime);
            this.waitForTransactionsToComplete(txContext, this.txTable.getRemoteTransactions(), key, transactionTopologyId, expectedEndTime);
            long remaining = expectedEndTime - this.nowMillis();
            if (remaining <= 0L) {
                throw this.newTimeoutException(key, txContext);
            }
            this.getLog().tracef("Finished waiting for other potential lockers, trying to acquire the lock on %s", key);
            this.lockManager.acquireLock(ctx, key, remaining, skipLocking);
        } else {
            this.getLog().tracef("Locking key %s, no need to check for pending locks.", key);
            this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        }
    }

    private void waitForTransactionsToComplete(TxInvocationContext txContext, Collection<? extends CacheTransaction> transactions, Object key, int transactionTopologyId, long expectedEndTime) throws InterruptedException {
        GlobalTransaction thisTransaction = txContext.getGlobalTransaction();
        for (CacheTransaction cacheTransaction : transactions) {
            long remaining;
            if (cacheTransaction.getTopologyId() >= transactionTopologyId || cacheTransaction.getGlobalTransaction().equals(thisTransaction)) continue;
            boolean txCompleted = false;
            while ((remaining = expectedEndTime - this.nowMillis()) > 0L) {
                if (!cacheTransaction.waitForLockRelease(key, remaining)) continue;
                txCompleted = true;
                break;
            }
            if (txCompleted) continue;
            throw this.newTimeoutException(key, txContext);
        }
    }

    private TimeoutException newTimeoutException(Object key, TxInvocationContext txContext) {
        return new TimeoutException("Could not acquire lock on " + key + " on behalf of transaction " + txContext.getGlobalTransaction() + ". Lock is being held by " + this.lockManager.getOwner(key));
    }

    private boolean releaseLockOnTxCompletion(TxInvocationContext ctx) {
        return ctx.isOriginLocal() || Configurations.isSecondPhaseAsync(this.cacheConfiguration);
    }

    private long nowMillis() {
        return System.nanoTime() / 1000000L;
    }
}

