/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.IOException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.AbstractJBossMarshaller;
import org.infinispan.marshall.jboss.DefaultContextClassResolver;
import org.infinispan.marshall.jboss.ExternalizerTable;
import org.jboss.marshalling.Externalize;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

public class JBossMarshaller
extends AbstractJBossMarshaller
implements StreamingMarshaller {
    ExternalizerTable externalizerTable;
    ExternalizerTableProxy proxy;
    GlobalConfiguration globalCfg;
    Configuration cfg;
    InvocationContextContainer icc;

    public JBossMarshaller() {
    }

    public JBossMarshaller(ExternalizerTable externalizerTable, Configuration cfg, InvocationContextContainer icc, GlobalConfiguration globalCfg) {
        this.externalizerTable = externalizerTable;
        this.globalCfg = globalCfg;
        this.cfg = cfg;
        this.icc = icc;
    }

    @Override
    public void start() {
        super.start();
        this.baseCfg.setObjectTable((ObjectTable)this.externalizerTable);
        this.proxy = new ExternalizerTableProxy(this.externalizerTable);
        this.baseCfg.setObjectTable((ObjectTable)this.proxy);
        Object classResolver = this.globalCfg.serialization().classResolver();
        if (classResolver == null) {
            ClassLoader cl = this.cfg == null ? this.globalCfg.classLoader() : this.cfg.classLoader();
            classResolver = new EmbeddedContextClassResolver(cl, this.icc);
        }
        this.baseCfg.setClassResolver(classResolver);
    }

    @Override
    public void stop() {
        super.stop();
        this.baseCfg.setClassResolver(null);
        this.proxy.clear();
    }

    @Override
    public boolean isMarshallableCandidate(Object o) {
        return super.isMarshallableCandidate(o) || this.externalizerTable.isMarshallableCandidate(o) || o.getClass().getAnnotation(SerializeWith.class) != null || o.getClass().getAnnotation(Externalize.class) != null;
    }

    private static final class ExternalizerTableProxy
    implements ObjectTable {
        private ExternalizerTable externalizerTable;

        public ExternalizerTableProxy(ExternalizerTable externalizerTable) {
            this.externalizerTable = externalizerTable;
            AbstractJBossMarshaller.log.tracef("Initialized proxy %s with table %s", (Object)this, (Object)externalizerTable);
        }

        public void clear() {
            this.externalizerTable = null;
            AbstractJBossMarshaller.log.tracef("Cleared proxy %s", (Object)this);
        }

        public ObjectTable.Writer getObjectWriter(Object o) throws IOException {
            return this.externalizerTable.getObjectWriter(o);
        }

        public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
            return this.externalizerTable.readObject(input);
        }
    }

    public static final class EmbeddedContextClassResolver
    extends DefaultContextClassResolver {
        private final InvocationContextContainer icc;

        public EmbeddedContextClassResolver(ClassLoader defaultClassLoader, InvocationContextContainer icc) {
            super(defaultClassLoader);
            this.icc = icc;
        }

        @Override
        protected ClassLoader getClassLoader() {
            ClassLoader cl;
            InvocationContext ctx;
            if (this.icc != null && (ctx = this.icc.getInvocationContext(true)) != null && (cl = ctx.getClassLoader()) != null) {
                return cl;
            }
            return super.getClassLoader();
        }
    }
}

