/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.remote.wrapper;

import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.remote.logging.Log;
import org.infinispan.loaders.remote.wrapper.EntryWrapper;
import org.infinispan.server.core.CacheValue;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.LogFactory;

public class HotRodEntryWrapper
implements EntryWrapper<ByteArrayKey, CacheValue> {
    private static final Log log = (Log)LogFactory.getLog(HotRodEntryWrapper.class, Log.class);

    @Override
    public ByteArrayKey wrapKey(Object key) throws CacheLoaderException {
        if (key instanceof ByteArrayKey) {
            return (ByteArrayKey)key;
        }
        throw log.unsupportedKeyFormat(key.getClass().getName());
    }

    @Override
    public CacheValue wrapValue(MetadataValue<?> value) throws CacheLoaderException {
        Object v = value.getValue();
        if (v instanceof byte[]) {
            return new CacheValue((byte[])v, value.getVersion());
        }
        throw log.unsupportedValueFormat(v != null ? v.getClass().getName() : "null");
    }
}

