/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote.recovery;

import javax.transaction.xa.Xid;
import org.infinispan.commands.remote.recovery.RecoveryCommand;
import org.infinispan.context.InvocationContext;

public class CompleteTransactionCommand
extends RecoveryCommand {
    public static final byte COMMAND_ID = 24;
    private Xid xid;
    private boolean commit;

    private CompleteTransactionCommand() {
        super(null);
    }

    public CompleteTransactionCommand(String cacheName) {
        super(cacheName);
    }

    public CompleteTransactionCommand(String cacheName, Xid xid, boolean commit) {
        super(cacheName);
        this.xid = xid;
        this.commit = commit;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        return this.recoveryManager.forceTransactionCompletion(this.xid, this.commit);
    }

    @Override
    public byte getCommandId() {
        return 24;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.xid, this.commit};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 24) {
            throw new IllegalArgumentException("Unexpected command id: " + commandId + ". Expected " + 24);
        }
        int i = 0;
        this.xid = (Xid)parameters[i++];
        this.commit = (Boolean)parameters[i++];
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ xid=" + this.xid + ", commit=" + this.commit + ", cacheName=" + this.cacheName + "} ";
    }
}

