/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.versioned;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.entries.versioned.Versioned;
import org.infinispan.container.entries.versioned.VersionedTransientMortalCacheValue;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class VersionedTransientMortalCacheEntry
extends TransientMortalCacheEntry
implements Versioned {
    public VersionedTransientMortalCacheEntry(Object key, Object value, EntryVersion version, long maxIdle, long lifespan) {
        super(key, new VersionedTransientMortalCacheValue(value, version, System.currentTimeMillis(), lifespan, maxIdle));
        this.touch(this.cacheValue.getCreated());
    }

    VersionedTransientMortalCacheEntry(Object key, Object value, EntryVersion version) {
        super(key, new VersionedTransientMortalCacheValue(value, version, System.currentTimeMillis()));
        this.touch(this.cacheValue.getCreated());
    }

    public VersionedTransientMortalCacheEntry(Object key, Object value, EntryVersion version, long maxIdle, long lifespan, long lastUsed, long created) {
        super(key, new VersionedTransientMortalCacheValue(value, version, created, lifespan, maxIdle, lastUsed));
    }

    VersionedTransientMortalCacheEntry(Object key, VersionedTransientMortalCacheValue cacheValue) {
        super(key, cacheValue);
    }

    @Override
    public EntryVersion getVersion() {
        return ((Versioned)((Object)this.cacheValue)).getVersion();
    }

    @Override
    public void setVersion(EntryVersion version) {
        ((Versioned)((Object)this.cacheValue)).setVersion(version);
    }

    public static class Externalizer
    extends AbstractExternalizer<VersionedTransientMortalCacheEntry> {
        @Override
        public void writeObject(ObjectOutput output, VersionedTransientMortalCacheEntry ice) throws IOException {
            output.writeObject(ice.key);
            output.writeObject(((VersionedTransientMortalCacheEntry)ice).cacheValue.value);
            output.writeObject(((Versioned)((Object)ice.cacheValue)).getVersion());
            UnsignedNumeric.writeUnsignedLong(output, ice.cacheValue.getCreated());
            output.writeLong(ice.cacheValue.getLifespan());
            UnsignedNumeric.writeUnsignedLong(output, ice.cacheValue.getLastUsed());
            output.writeLong(ice.cacheValue.getMaxIdle());
        }

        @Override
        public VersionedTransientMortalCacheEntry readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object k = input.readObject();
            Object v = input.readObject();
            EntryVersion version = (EntryVersion)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            Long lifespan = input.readLong();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new VersionedTransientMortalCacheEntry(k, v, version, maxIdle, lifespan, lastUsed, created);
        }

        @Override
        public Integer getId() {
            return 79;
        }

        @Override
        public Set<Class<? extends VersionedTransientMortalCacheEntry>> getTypeClasses() {
            return Util.asSet(VersionedTransientMortalCacheEntry.class);
        }
    }
}

