/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.locking.AbstractLockingInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTransactionalLockingInterceptor
extends AbstractLockingInterceptor {
    private static final Log log = LogFactory.getLog(NonTransactionalLockingInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            if (!this.shouldLock(command.getKey(), command)) {
                Object object = this.invokeNextInterceptor(ctx, command);
                return object;
            }
            this.lockKey(ctx, command);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        for (Object key : this.dataContainer.keySet()) {
            if (!this.shouldLock(key, command)) continue;
            this.lockKey(ctx, key, lockTimeout, skipLocking);
        }
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            boolean skipLocking = this.hasSkipLocking(command);
            long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
            if (!command.isForwarded()) {
                for (Object key : command.getMap().keySet()) {
                    if (!this.shouldLock(key, command)) continue;
                    this.lockKey(ctx, key, lockTimeout, skipLocking);
                }
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            if (!this.shouldLock(command.getKey(), command)) {
                Object object = this.invokeNextInterceptor(ctx, command);
                return object;
            }
            this.lockKey(ctx, command);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        this.assertNonTransactional(ctx);
        try {
            if (!this.shouldLock(command.getKey(), command)) {
                Object object = this.invokeNextInterceptor(ctx, command);
                return object;
            }
            this.lockKey(ctx, command);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            throw this.cleanLocksAndRethrow(ctx, te);
        }
        finally {
            this.lockManager.unlockAll(ctx);
        }
    }

    @Override
    public final Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        command.setFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
        return this.visitRemoveCommand(ctx, command);
    }

    private void assertNonTransactional(InvocationContext ctx) {
        if (ctx.isInTxScope()) {
            throw new InvalidCacheUsageException("This is a non-transactional cache and cannot be accessed with a transactional InvocationContext.");
        }
    }

    private boolean shouldLock(Object key, FlagAffectedCommand command) {
        if (this.hasSkipLocking(command)) {
            return false;
        }
        if (!this.cacheConfiguration.clustering().cacheMode().isClustered()) {
            return true;
        }
        boolean shouldLock = this.cdl.localNodeIsPrimaryOwner(key);
        log.tracef("Are (%s) we the lock owners for key '%s'? %s", this.cdl.getAddress(), key, shouldLock);
        return shouldLock;
    }

    private void lockKey(InvocationContext ctx, DataWriteCommand command) throws InterruptedException {
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        this.lockKey(ctx, command.getKey(), lockTimeout, skipLocking);
    }
}

