/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.jdbc;

import java.util.Properties;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ConnectionFactoryConfig;
import org.infinispan.util.TypedProperties;

public abstract class AbstractJdbcCacheStoreConfig
extends LockSupportCacheStoreConfig {
    protected ConnectionFactoryConfig connectionFactoryConfig = new ConnectionFactoryConfig();

    protected AbstractJdbcCacheStoreConfig(ConnectionFactoryConfig connectionFactoryConfig) {
        this.connectionFactoryConfig = connectionFactoryConfig;
        Properties p = this.getProperties();
        this.setProperty(connectionFactoryConfig.getDriverClass(), "driverClass", p);
        this.setProperty(connectionFactoryConfig.getConnectionUrl(), "connectionUrl", p);
        this.setProperty(connectionFactoryConfig.getUserName(), "userName", p);
        this.setProperty(connectionFactoryConfig.getPassword(), "password", p);
        this.setProperty(connectionFactoryConfig.getConnectionFactoryClass(), "connectionFactoryClass", p);
        this.setProperty(connectionFactoryConfig.getDatasourceJndiLocation(), "datasourceJndiLocation", p);
    }

    protected AbstractJdbcCacheStoreConfig() {
    }

    public void setConnectionFactoryClass(String connectionFactoryClass) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionFactoryClass(connectionFactoryClass);
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.connectionFactoryConfig;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setConnectionUrl(connectionUrl);
    }

    public void setUserName(String userName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setUserName(userName);
    }

    public void setDatasourceJndiLocation(String location) {
        this.testImmutability("datasourceJndiLocation");
        this.connectionFactoryConfig.setDatasourceJndiLocation(location);
    }

    public void setPassword(String password) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setPassword(password);
    }

    public void setDriverClass(String driverClassName) {
        this.testImmutability("connectionFactoryConfig");
        this.connectionFactoryConfig.setDriverClass(driverClassName);
    }

    public AbstractJdbcCacheStoreConfig clone() {
        AbstractJdbcCacheStoreConfig result = (AbstractJdbcCacheStoreConfig)super.clone();
        result.connectionFactoryConfig = this.connectionFactoryConfig.clone();
        return result;
    }

    public String toString() {
        return "AbstractJdbcCacheStoreConfig{connectionFactoryConfig=" + this.connectionFactoryConfig + "} " + super.toString();
    }

    protected void setProperty(String properyValue, String propertyName, Properties p) {
        if (properyValue != null) {
            try {
                p.setProperty(propertyName, properyValue);
            }
            catch (UnsupportedOperationException e) {
                TypedProperties writableProperties = new TypedProperties(p);
                writableProperties.setProperty(propertyName, properyValue);
                this.setProperties((Properties)writableProperties);
            }
        }
    }
}

