/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.InfinispanCollections;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PrepareCommand
extends AbstractTransactionBoundaryCommand {
    private static final Log log = LogFactory.getLog(PrepareCommand.class);
    private boolean trace = log.isTraceEnabled();
    public static final byte COMMAND_ID = 12;
    protected WriteCommand[] modifications;
    protected boolean onePhaseCommit;
    protected CacheNotifier notifier;
    protected RecoveryManager recoveryManager;
    private transient boolean replayEntryWrapping = false;
    private static final WriteCommand[] EMPTY_WRITE_COMMAND_ARRAY = new WriteCommand[0];

    public void initialize(CacheNotifier notifier, RecoveryManager recoveryManager) {
        this.notifier = notifier;
        this.recoveryManager = recoveryManager;
    }

    private PrepareCommand() {
        super(null);
    }

    public PrepareCommand(String cacheName, GlobalTransaction gtx, boolean onePhaseCommit, WriteCommand ... modifications) {
        super(cacheName);
        this.globalTx = gtx;
        this.modifications = modifications;
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand(String cacheName, GlobalTransaction gtx, List<WriteCommand> commands, boolean onePhaseCommit) {
        super(cacheName);
        this.globalTx = gtx;
        this.modifications = commands == null || commands.isEmpty() ? null : commands.toArray(new WriteCommand[commands.size()]);
        this.onePhaseCommit = onePhaseCommit;
    }

    public PrepareCommand(String cacheName) {
        super(cacheName);
    }

    @Override
    public Object perform(InvocationContext ignored) throws Throwable {
        if (ignored != null) {
            throw new IllegalStateException("Expected null context!");
        }
        if (this.recoveryManager != null && this.recoveryManager.isTransactionPrepared(this.globalTx)) {
            log.tracef("The transaction %s is already prepared. Skipping prepare call.", this.globalTx);
            return null;
        }
        RemoteTransaction remoteTransaction = this.txTable.getOrCreateRemoteTransaction(this.globalTx, this.modifications);
        if (this.hasModifications()) {
            remoteTransaction.setModifications(Arrays.asList(this.modifications));
        }
        RemoteTxInvocationContext ctx = this.icc.createRemoteTxInvocationContext(remoteTransaction, this.getOrigin());
        if (this.trace) {
            log.tracef("Invoking remotely originated prepare: %s with invocation context: %s", this, ctx);
        }
        this.notifier.notifyTransactionRegistered(ctx.getGlobalTransaction(), ctx);
        return this.invoker.invoke(ctx, this);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPrepareCommand((TxInvocationContext)ctx, this);
    }

    public WriteCommand[] getModifications() {
        return this.modifications == null ? EMPTY_WRITE_COMMAND_ARRAY : this.modifications;
    }

    public boolean isOnePhaseCommit() {
        return this.onePhaseCommit;
    }

    @Override
    public byte getCommandId() {
        return 12;
    }

    @Override
    public Object[] getParameters() {
        int numMods = this.modifications == null ? 0 : this.modifications.length;
        int i = 0;
        int params = 3;
        Object[] retval = new Object[numMods + 3];
        retval[i++] = this.globalTx;
        retval[i++] = this.onePhaseCommit;
        retval[i++] = numMods;
        if (numMods > 0) {
            System.arraycopy(this.modifications, 0, retval, 3, numMods);
        }
        return retval;
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        int numMods;
        int i = 0;
        this.globalTx = (GlobalTransaction)args[i++];
        this.onePhaseCommit = (Boolean)args[i++];
        if ((numMods = ((Integer)args[i++]).intValue()) > 0) {
            this.modifications = new WriteCommand[numMods];
            System.arraycopy(args, i, this.modifications, 0, numMods);
        }
    }

    public PrepareCommand copy() {
        PrepareCommand copy = new PrepareCommand(this.cacheName);
        copy.globalTx = this.globalTx;
        copy.modifications = this.modifications == null ? null : (WriteCommand[])this.modifications.clone();
        copy.onePhaseCommit = this.onePhaseCommit;
        return copy;
    }

    @Override
    public String toString() {
        return "PrepareCommand {modifications=" + (this.modifications == null ? null : Arrays.asList(this.modifications)) + ", onePhaseCommit=" + this.onePhaseCommit + ", " + super.toString();
    }

    public boolean hasModifications() {
        return this.modifications != null && this.modifications.length > 0;
    }

    public Set<Object> getAffectedKeys() {
        if (this.modifications == null || this.modifications.length == 0) {
            return InfinispanCollections.emptySet();
        }
        if (this.modifications.length == 1) {
            return this.modifications[0].getAffectedKeys();
        }
        HashSet<Object> keys = new HashSet<Object>(this.modifications.length);
        for (WriteCommand wc : this.modifications) {
            keys.addAll(wc.getAffectedKeys());
        }
        return keys;
    }

    public boolean isReplayEntryWrapping() {
        return this.replayEntryWrapping;
    }

    public void setReplayEntryWrapping(boolean replayEntryWrapping) {
        this.replayEntryWrapping = replayEntryWrapping;
    }

    public boolean writesToASingleKey() {
        if (this.modifications == null || this.modifications.length != 1) {
            return false;
        }
        WriteCommand wc = this.modifications[0];
        return wc instanceof PutKeyValueCommand || wc instanceof RemoveCommand || wc instanceof ReplaceCommand;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }
}

