/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.AbstractExternalizer;

public class ApplyDeltaCommand
extends AbstractDataWriteCommand {
    public static final int COMMAND_ID = 25;
    private Collection<Object> keys;
    private Delta delta;

    public ApplyDeltaCommand() {
    }

    public ApplyDeltaCommand(Object deltaAwareValueKey, Delta delta, Collection<Object> keys) {
        super(deltaAwareValueKey, EnumSet.of(Flag.DELTA_WRITE));
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("At least one key to be locked needs to be specified");
        }
        this.keys = keys;
        this.delta = delta;
    }

    public Delta getDelta() {
        return this.delta;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        return null;
    }

    @Override
    public byte getCommandId() {
        return 25;
    }

    @Override
    public String toString() {
        return "ApplyDeltaCommand[key=" + this.key + ", delta=" + this.delta + ", keys=" + this.keys + ']';
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.delta, this.keys, Flag.copyWithoutRemotableFlags(this.flags)};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 25) {
            throw new IllegalStateException("Unsupported command id:" + commandId);
        }
        int i = 0;
        this.key = args[i++];
        this.delta = (Delta)args[i++];
        this.keys = (List)args[i++];
        this.flags = (Set)args[i];
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitApplyDeltaCommand(ctx, this);
    }

    public Object[] getKeys() {
        return this.keys.toArray();
    }

    public Object[] getCompositeKeys() {
        Object[] compositeKeys = new DeltaCompositeKey[this.keys.size()];
        int i = 0;
        for (Object k : this.keys) {
            compositeKeys[i++] = new DeltaCompositeKey(this.key, k);
        }
        return compositeKeys;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        switch (status) {
            case FAILED: 
            case INITIALIZING: 
            case STOPPING: 
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplyDeltaCommand)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplyDeltaCommand that = (ApplyDeltaCommand)o;
        return this.keys.equals(that.keys);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.keys.hashCode();
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    public static class DeltaCompositeKeyExternalizer
    extends AbstractExternalizer<DeltaCompositeKey> {
        @Override
        public void writeObject(ObjectOutput output, DeltaCompositeKey dck) throws IOException {
            output.writeObject(dck.deltaAwareValueKey);
            output.writeObject(dck.entryKey);
        }

        @Override
        public DeltaCompositeKey readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            Object deltaAwareValueKey = unmarshaller.readObject();
            Object entryKey = unmarshaller.readObject();
            return new DeltaCompositeKey(deltaAwareValueKey, entryKey);
        }

        @Override
        public Integer getId() {
            return 97;
        }

        @Override
        public Set<Class<? extends DeltaCompositeKey>> getTypeClasses() {
            return Collections.singleton(DeltaCompositeKey.class);
        }
    }

    private static final class DeltaCompositeKey {
        private final Object deltaAwareValueKey;
        private final Object entryKey;

        public DeltaCompositeKey(Object deltaAwareValueKey, Object entryKey) {
            if (deltaAwareValueKey == null || entryKey == null) {
                throw new IllegalArgumentException("Keys cannot be null");
            }
            this.deltaAwareValueKey = deltaAwareValueKey;
            this.entryKey = entryKey;
        }

        public int hashCode() {
            return 31 * this.deltaAwareValueKey.hashCode() + this.entryKey.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DeltaCompositeKey)) {
                return false;
            }
            DeltaCompositeKey other = (DeltaCompositeKey)obj;
            return this.deltaAwareValueKey.equals(other.deltaAwareValueKey) && this.entryKey.equals(other.entryKey);
        }

        public String toString() {
            return "DeltaCompositeKey[deltaAwareValueKey=" + this.deltaAwareValueKey + ", entryKey=" + this.entryKey + ']';
        }
    }
}

