/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.as;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    CACHE_CONTAINER("cache-container"),
    DISTRIBUTED_CACHE("distributed-cache"),
    EVICTION("eviction"),
    EXPIRATION("expiration"),
    FILE_STORE("file-store"),
    INET_ADDRESS("inet-address"),
    INTERFACE("interface"),
    INTERFACES("interfaces"),
    INVALIDATION_CACHE("invalidation-cache"),
    LOCAL_CACHE("local-cache"),
    LOCKING("locking"),
    OUTBOUND_SOCKET_BINDING("outbound-socket-binding"),
    PROFILE("profile"),
    PROPERTY("property"),
    PROTOCOL("protocol"),
    REMOTE_DESTINATION("remote-destination"),
    REPLICATED_CACHE("replicated-cache"),
    ROOT("server"),
    SOCKET_BINDING("socket-binding"),
    SOCKET_BINDING_GROUP("socket-binding-group"),
    STACK("stack"),
    STATE_TRANSFER("state-transfer"),
    STORE("store"),
    SUBSYSTEM("subsystem"),
    TRANSACTION("transaction"),
    TRANSPORT("transport"),
    WRITE_BEHIND("write-behind"),
    THREAD_FACTORY("thread-factory"),
    UNBOUNDED_QUEUE_THREAD_POOL("unbounded-queue-thread-pool"),
    BOUNDED_QUEUE_THREAD_POOL("bounded-queue-thread-pool"),
    BLOCKING_BOUNDED_QUEUE_THREAD_POOL("blocking-bounded-queue-thread-pool"),
    QUEUELESS_THREAD_POOL("queueless-thread-pool"),
    SCHEDULED_THREAD_POOL("scheduled-thread-pool");

    private static final Map<String, Element> MAP;
    private final String name;

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

