/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractInvocationContext
implements InvocationContext {
    protected byte contextFlags = 0;
    private Address origin;
    private ClassLoader classLoader;

    protected final boolean isContextFlagSet(ContextFlag flag) {
        return (this.contextFlags & flag.mask) != 0;
    }

    protected final void setContextFlag(ContextFlag flag) {
        this.contextFlags = (byte)(this.contextFlags | flag.mask);
    }

    protected final void unsetContextFlag(ContextFlag flag) {
        this.contextFlags = (byte)(this.contextFlags & ~flag.mask);
    }

    protected final void setContextFlag(ContextFlag flag, boolean set) {
        if (set) {
            this.setContextFlag(flag);
        } else {
            this.unsetContextFlag(flag);
        }
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    public void setOrigin(Address origin) {
        this.origin = origin;
    }

    @Override
    public boolean hasLockedKey(Object key) {
        return this.getLockedKeys().contains(key);
    }

    @Override
    public boolean isUseFutureReturnType() {
        return this.isContextFlagSet(ContextFlag.USE_FUTURE_RETURN_TYPE);
    }

    @Override
    public void setUseFutureReturnType(boolean useFutureReturnType) {
        this.setContextFlag(ContextFlag.USE_FUTURE_RETURN_TYPE, useFutureReturnType);
    }

    @Override
    public AbstractInvocationContext clone() {
        try {
            return (AbstractInvocationContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean replaceValue(Object key, Object value) {
        CacheEntry ce = this.lookupEntry(key);
        if (ce == null || ce.isNull() || ce.isLockPlaceholder() || ce.getValue() == null) {
            if (ce != null && ce.isChanged()) {
                ce.setValue(value);
            } else {
                return false;
            }
        }
        return true;
    }

    protected static enum ContextFlag {
        USE_FUTURE_RETURN_TYPE(1),
        ORIGIN_LOCAL(2);

        final byte mask;

        private ContextFlag(int mask) {
            this.mask = (byte)mask;
        }
    }
}

