/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.Immutable;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.MarshallUtil;
import org.infinispan.util.Util;
import org.jboss.marshalling.util.IdentityIntMap;

@Immutable
public class SetExternalizer
extends AbstractExternalizer<Set> {
    private static final int HASH_SET = 0;
    private static final int TREE_SET = 1;
    private final IdentityIntMap<Class<?>> numbers = new IdentityIntMap(2);

    public SetExternalizer() {
        this.numbers.put(HashSet.class, 0);
        this.numbers.put(TreeSet.class, 1);
    }

    @Override
    public void writeObject(ObjectOutput output, Set set) throws IOException {
        int number = this.numbers.get(set.getClass(), -1);
        output.writeByte(number);
        if (number == 1) {
            output.writeObject(((TreeSet)set).comparator());
        }
        MarshallUtil.marshallCollection(set, output);
    }

    @Override
    public Set readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        AbstractSet subject = null;
        switch (magicNumber) {
            case 0: {
                subject = new HashSet();
                break;
            }
            case 1: {
                Comparator comparator = (Comparator)input.readObject();
                subject = new TreeSet(comparator);
            }
        }
        int size = UnsignedNumeric.readUnsignedInt(input);
        for (int i = 0; i < size; ++i) {
            subject.add(input.readObject());
        }
        return subject;
    }

    @Override
    public Integer getId() {
        return 3;
    }

    @Override
    public Set<Class<? extends Set>> getTypeClasses() {
        return Util.asSet(HashSet.class, TreeSet.class);
    }
}

